/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.inventory.container.ContainerUpgradeManagement;
import mekanism.common.network.PacketRemoveUpgrade;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiUpgradeManagement
extends GuiMekanism {
    public IUpgradeTile tileEntity;
    public Upgrade selectedType;
    public boolean isDragging = false;
    public int dragOffset = 0;
    public int supportedIndex;
    public int delay;
    public float scroll;

    public GuiUpgradeManagement(InventoryPlayer inventory, IUpgradeTile tile) {
        super(new ContainerUpgradeManagement(inventory, tile));
        this.tileEntity = tile;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.delay < 40) {
            ++this.delay;
        } else {
            this.delay = 0;
            ++this.supportedIndex;
            this.supportedIndex %= this.tileEntity.getComponent().getSupportedTypes().size();
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int index;
        Upgrade[] supported;
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiUpgradeManagement.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(84, 8 + this.getScroll(), 202, 0, 4, 4);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.upgrades.supported") + ":", 26, 59, 0x404040);
        if (this.selectedType == null) {
            this.renderText(LangUtils.localize("gui.upgrades.noSelection") + ".", 92, 8, 0.8f, true);
        } else {
            int amount = this.tileEntity.getComponent().getUpgrades(this.selectedType);
            this.renderText(this.selectedType.getName() + " " + LangUtils.localize("gui.upgrade"), 92, 8, 0.6f, true);
            this.renderText(LangUtils.localize("gui.upgrades.amount") + ": " + amount + "/" + this.selectedType.getMax(), 92, 16, 0.6f, true);
            int text = 0;
            for (String s : this.selectedType.getInfo((TileEntity)this.tileEntity)) {
                this.renderText(s, 92, 22 + 6 * text++, 0.6f, true);
            }
        }
        if (!this.tileEntity.getComponent().getSupportedTypes().isEmpty() && (supported = this.tileEntity.getComponent().getSupportedTypes().toArray(new Upgrade[this.tileEntity.getComponent().getSupportedTypes().size()])).length > this.supportedIndex) {
            this.renderUpgrade(supported[this.supportedIndex], 80, 57, 0.8f, true);
            this.field_146289_q.func_78276_b(supported[this.supportedIndex].getName(), 96, 59, 0x404040);
        }
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[this.getCurrentUpgrades().size()]);
        for (int i = 0; i < 4 && (index = this.getUpgradeIndex() + i) <= upgrades.length - 1; ++i) {
            Upgrade upgrade = upgrades[index];
            int xPos = 25;
            int yPos = 7 + i * 12;
            boolean yRender = false;
            this.field_146289_q.func_78276_b(upgrade.getName(), xPos + 12, yPos + 2, 0x404040);
            this.renderUpgrade(upgrade, xPos + 2, yPos + 2, 0.5f, true);
            if (xAxis < xPos || xAxis > xPos + 58 || yAxis < yPos || yAxis > yPos + 12) continue;
            this.func_146283_a(MekanismUtils.splitLines(upgrade.getDescription()), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    private void renderText(String text, int x, int y, float size, boolean scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)size, (float)size, (float)size);
        this.field_146289_q.func_78276_b(text, scale ? (int)(1.0f / size * (float)x) : x, scale ? (int)(1.0f / size * (float)y) : y, 52480);
        GL11.glPopMatrix();
    }

    private void renderUpgrade(Upgrade type, int x, int y, float size, boolean scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)size, (float)size, (float)size);
        GL11.glEnable((int)2896);
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), type.getStack(), scale ? (int)(1.0f / size * (float)x) : x, scale ? (int)(1.0f / size * (float)y) : y);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int index;
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiUpgradeManagement.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20) {
            this.func_73729_b(guiWidth + 6, guiHeight + 6, 176, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 6, guiHeight + 6, 176, 14, 14, 14);
        }
        if (this.selectedType == null) {
            this.func_73729_b(guiWidth + 136, guiHeight + 57, 190, 24, 12, 12);
        } else if (xAxis >= 136 && xAxis <= 148 && yAxis >= 57 && yAxis <= 69) {
            this.func_73729_b(guiWidth + 136, guiHeight + 57, 190, 0, 12, 12);
        } else {
            this.func_73729_b(guiWidth + 136, guiHeight + 57, 190, 12, 12, 12);
        }
        int displayInt = this.tileEntity.getComponent().getScaledUpgradeProgress(14);
        this.func_73729_b(guiWidth + 154, guiHeight + 26, 176, 28, 10, displayInt);
        if (this.selectedType != null && this.tileEntity.getComponent().getUpgrades(this.selectedType) == 0) {
            this.selectedType = null;
        }
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[this.getCurrentUpgrades().size()]);
        for (int i = 0; i < 4 && (index = this.getUpgradeIndex() + i) <= upgrades.length - 1; ++i) {
            Upgrade upgrade = upgrades[index];
            int xPos = 25;
            int yPos = 7 + i * 12;
            int yRender = 0;
            yRender = upgrade == this.selectedType ? 190 : (xAxis >= xPos && xAxis <= xPos + 58 && yAxis >= yPos && yAxis <= yPos + 12 ? 166 : 178);
            MekanismRenderer.color(upgrade.getColor(), 1.0f, 2.5f);
            this.func_73729_b(guiWidth + xPos, guiHeight + yPos, 0, yRender, 58, 12);
            MekanismRenderer.resetColor();
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    private Set<Upgrade> getCurrentUpgrades() {
        return this.tileEntity.getComponent().getInstalledTypes();
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 42.0f), 42), 0);
    }

    public int getUpgradeIndex() {
        if (this.getCurrentUpgrades().size() <= 4) {
            return 0;
        }
        return (int)((float)this.getCurrentUpgrades().size() * this.scroll - 4.0f / (float)this.getCurrentUpgrades().size() * this.scroll);
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (this.isDragging) {
            this.scroll = Math.min(Math.max((float)(yAxis - 8 - this.dragOffset) / 42.0f, 0.0f), 1.0f);
        }
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int type) {
        super.func_146286_b(mouseX, mouseY, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        TileEntity tile = (TileEntity)this.tileEntity;
        if (button == 0) {
            if (xAxis >= 84 && xAxis <= 88 && yAxis >= this.getScroll() + 8 && yAxis <= this.getScroll() + 8 + 4) {
                if (this.getCurrentUpgrades().size() > 4) {
                    this.dragOffset = yAxis - (this.getScroll() + 8);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            if (xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20) {
                int guiId = BlockMachine.MachineType.get((Block)tile.func_145838_q(), (int)tile.func_145832_p()).guiId;
                SoundHandler.playSound("gui.button.press");
                Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), guiId));
            }
            if (this.selectedType != null && xAxis >= 136 && xAxis <= 148 && yAxis >= 57 && yAxis <= 69) {
                SoundHandler.playSound("gui.button.press");
                Mekanism.packetHandler.sendToServer(new PacketRemoveUpgrade.RemoveUpgradeMessage(Coord4D.get(tile), this.selectedType.ordinal()));
            }
            int counter = 0;
            for (Upgrade upgrade : this.getCurrentUpgrades()) {
                int xPos = 25;
                int yPos = 7 + counter++ * 12;
                boolean yRender = false;
                if (xAxis < xPos || xAxis > xPos + 58 || yAxis < yPos || yAxis > yPos + 12) continue;
                this.selectedType = upgrade;
                break;
            }
        }
    }
}

