/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Collection;
import java.util.Set;
import mekanism.api.IHeatTransfer;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;

public class HeatNetwork
extends DynamicNetwork<IHeatTransfer, HeatNetwork> {
    public double meanTemp = 0.0;
    public double heatLost = 0.0;
    public double heatTransferred = 0.0;

    public HeatNetwork() {
    }

    public HeatNetwork(Collection<HeatNetwork> networks) {
        for (HeatNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    @Override
    public String getNeededInfo() {
        return "Not Applicable";
    }

    @Override
    public String getStoredInfo() {
        return this.meanTemp + "K above ambient";
    }

    @Override
    public String getFlowInfo() {
        return this.heatTransferred + " transferred to acceptors,  " + this.heatLost + " lost to environment, " + (this.heatTransferred + this.heatLost == 0.0 ? "" : this.heatTransferred / (this.heatTransferred + this.heatLost) * 100.0 + "% efficiency");
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IHeatTransfer, HeatNetwork> transmitter) {
    }

    @Override
    public void clampBuffer() {
    }

    @Override
    public Set<IHeatTransfer> getAcceptors(Object data) {
        return null;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        double newSumTemp = 0.0;
        double newHeatLost = 0.0;
        double newHeatTransferred = 0.0;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            IHeatTransfer heatTransmitter;
            for (IGridTransmitter transmitter : this.transmitters) {
                if (!(transmitter instanceof IHeatTransfer)) continue;
                heatTransmitter = (IHeatTransfer)((Object)transmitter);
                double[] d = heatTransmitter.simulateHeat();
                newHeatTransferred += d[0];
                newHeatLost += d[1];
            }
            for (IGridTransmitter transmitter : this.transmitters) {
                if (!(transmitter instanceof IHeatTransfer)) continue;
                heatTransmitter = (IHeatTransfer)((Object)transmitter);
                newSumTemp += heatTransmitter.applyTemperatureChange();
            }
        }
        this.heatLost = newHeatLost;
        this.heatTransferred = newHeatTransferred;
        this.meanTemp = newSumTemp / (double)this.transmitters.size();
    }
}

