/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBlockBasic
extends ItemBlock
implements IEnergizedItem {
    public Block metaBlock;

    public ItemBlockBasic(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
    }

    public int getItemStackLimit(ItemStack stack) {
        if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock && stack.func_77960_j() == 6) {
            return new InventoryBin(stack).getItemCount() == 0 ? super.getItemStackLimit(stack) : 1;
        }
        return super.getItemStackLimit(stack);
    }

    public ItemStack getUnchargedCell(Tier.InductionCellTier tier) {
        ItemStack stack = new ItemStack(MekanismBlocks.BasicBlock2, 1, 3);
        this.setTier(stack, tier.getBaseTier());
        return stack;
    }

    public ItemStack getUnchargedProvider(Tier.InductionProviderTier tier) {
        ItemStack stack = new ItemStack(MekanismBlocks.BasicBlock2, 1, 4);
        this.setTier(stack, tier.getBaseTier());
        return stack;
    }

    public Tier.BaseTier getTier(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Tier.BaseTier.BASIC;
        }
        return Tier.BaseTier.values()[itemstack.field_77990_d.func_74762_e("tier")];
    }

    public void setTier(ItemStack itemstack, Tier.BaseTier tier) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74768_a("tier", tier.ordinal());
    }

    public int func_77647_b(int i) {
        return i;
    }

    public IIcon func_77617_a(int i) {
        return this.metaBlock.func_149691_a(2, i);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock && itemstack.func_77960_j() == 6) {
            InventoryBin inv = new InventoryBin(itemstack);
            if (inv.getItemCount() > 0) {
                list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + inv.getItemType().func_82833_r());
                list.add((Object)((Object)EnumColor.INDIGO) + "Item amount: " + (Object)((Object)EnumColor.GREY) + inv.getItemCount());
            } else {
                list.add((Object)((Object)EnumColor.DARK_RED) + "Empty");
            }
        } else if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock2) {
            if (itemstack.func_77960_j() == 3) {
                Tier.InductionCellTier tier = Tier.InductionCellTier.values()[this.getTier(itemstack).ordinal()];
                list.add((Object)((Object)tier.getBaseTier().getColor()) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(tier.maxEnergy));
            } else if (itemstack.func_77960_j() == 4) {
                Tier.InductionProviderTier tier = Tier.InductionProviderTier.values()[this.getTier(itemstack).ordinal()];
                list.add((Object)((Object)tier.getBaseTier().getColor()) + LangUtils.localize("tooltip.outputRate") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(tier.output));
            }
        }
        if (this.getMaxEnergy(itemstack) > 0.0) {
            list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.func_77960_j() == 6 && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("newCount");
    }

    public boolean func_77630_h(ItemStack stack) {
        if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock && stack.func_77960_j() != 6) {
            return true;
        }
        return stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("newCount");
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!(Block.func_149634_a((Item)this) != MekanismBlocks.BasicBlock || stack.func_77960_j() == 6 && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("newCount"))) {
            return null;
        }
        ItemStack ret = stack.func_77946_l();
        ret.field_77990_d.func_74768_a("itemCount", stack.field_77990_d.func_74762_e("newCount"));
        return ret;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntity tileEntity;
            if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock) {
                if (stack.func_77960_j() == 6 && stack.field_77990_d != null) {
                    tileEntity = (TileEntityBin)world.func_147438_o(x, y, z);
                    InventoryBin inv = new InventoryBin(stack);
                    if (inv.getItemType() != null) {
                        tileEntity.setItemType(inv.getItemType());
                    }
                    tileEntity.setItemCount(inv.getItemCount());
                }
            } else if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock2) {
                if (stack.func_77960_j() == 3) {
                    tileEntity = (TileEntityInductionCell)world.func_147438_o(x, y, z);
                    tileEntity.tier = Tier.InductionCellTier.values()[this.getTier(stack).ordinal()];
                    if (!world.field_72995_K) {
                        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
                    }
                } else if (stack.func_77960_j() == 4) {
                    tileEntity = (TileEntityInductionProvider)world.func_147438_o(x, y, z);
                    tileEntity.tier = Tier.InductionProviderTier.values()[this.getTier(stack).ordinal()];
                    if (!world.field_72995_K) {
                        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
                    }
                }
            }
            if ((tileEntity = world.func_147438_o(x, y, z)) instanceof IStrictEnergyStorage && !(tileEntity instanceof TileEntityMultiblock)) {
                ((IStrictEnergyStorage)tileEntity).setEnergy(this.getEnergy(stack));
            }
        }
        return place;
    }

    public String func_77667_c(ItemStack itemstack) {
        String name = "";
        if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock) {
            switch (itemstack.func_77960_j()) {
                case 0: {
                    name = "OsmiumBlock";
                    break;
                }
                case 1: {
                    name = "BronzeBlock";
                    break;
                }
                case 2: {
                    name = "RefinedObsidian";
                    break;
                }
                case 3: {
                    name = "CharcoalBlock";
                    break;
                }
                case 4: {
                    name = "RefinedGlowstone";
                    break;
                }
                case 5: {
                    name = "SteelBlock";
                    break;
                }
                case 6: {
                    name = "Bin";
                    break;
                }
                case 7: {
                    name = "TeleporterFrame";
                    break;
                }
                case 8: {
                    name = "SteelCasing";
                    break;
                }
                case 9: {
                    name = "DynamicTank";
                    break;
                }
                case 10: {
                    name = "DynamicGlass";
                    break;
                }
                case 11: {
                    name = "DynamicValve";
                    break;
                }
                case 12: {
                    name = "CopperBlock";
                    break;
                }
                case 13: {
                    name = "TinBlock";
                    break;
                }
                case 14: {
                    name = "SolarEvaporationController";
                    break;
                }
                case 15: {
                    name = "SolarEvaporationValve";
                    break;
                }
                default: {
                    name = "Unknown";
                    break;
                }
            }
        } else if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock2) {
            switch (itemstack.func_77960_j()) {
                case 0: {
                    name = "SolarEvaporationBlock";
                    break;
                }
                case 1: {
                    name = "InductionCasing";
                    break;
                }
                case 2: {
                    name = "InductionPort";
                    break;
                }
                case 3: {
                    name = "InductionCell" + this.getTier(itemstack).getName();
                    break;
                }
                case 4: {
                    name = "InductionProvider" + this.getTier(itemstack).getName();
                }
            }
        }
        return this.func_77658_a() + "." + name;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock2 && itemStack.func_77960_j() == 3) {
            if (itemStack.field_77990_d == null) {
                return 0.0;
            }
            return itemStack.field_77990_d.func_74769_h("energyStored");
        }
        return 0.0;
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock2 && itemStack.func_77960_j() == 3) {
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74780_a("energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
        }
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        if (Block.func_149634_a((Item)this) == MekanismBlocks.BasicBlock2 && itemStack.func_77960_j() == 3) {
            return Tier.InductionCellTier.values()[this.getTier((ItemStack)itemStack).ordinal()].maxEnergy;
        }
        return 0.0;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isMetadataSpecific(ItemStack itemStack) {
        return true;
    }
}

