/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.colour.ColourRGBA;
import mekanism.api.IHeatTransfer;
import mekanism.common.HeatNetwork;
import mekanism.common.multipart.MultipartTransmitter;
import mekanism.common.multipart.PartHeatTransmitter;
import mekanism.common.util.HeatUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class MultipartHeatTransmitter
extends MultipartTransmitter<IHeatTransfer, HeatNetwork>
implements IHeatTransfer {
    public double temperature = 0.0;
    public double clientTemperature = 0.0;
    public double heatToAbsorb = 0.0;
    public HeatMaterial material = HeatMaterial.DEFAULT;

    public MultipartHeatTransmitter(PartHeatTransmitter multiPart) {
        super(multiPart);
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return this.material.inverseConduction;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return this.material.inverseConductionInsulation;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.material.inverseHeatCapacity * this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        if (Math.abs(this.temperature - this.clientTemperature) > this.temperature / 100.0) {
            this.clientTemperature = this.temperature;
            this.getPart().sendTemp();
        }
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return true;
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        TileEntity adj;
        this.getPart();
        if (PartHeatTransmitter.connectionMapContainsSide(this.getPart().getAllCurrentConnections(), side) && (adj = this.coord().getFromSide(side).getTileEntity((IBlockAccess)this.world())) instanceof IHeatTransfer) {
            return (IHeatTransfer)adj;
        }
        return null;
    }

    public PartHeatTransmitter getPart() {
        return (PartHeatTransmitter)this.containingPart;
    }

    public static enum HeatMaterial {
        DEFAULT(5.0, 1.0, 0.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0));

        double inverseConduction;
        double inverseHeatCapacity;
        double inverseConductionInsulation;
        ColourRGBA baseColour;

        private HeatMaterial(double inversek, double inverseC, double insulationInversek, ColourRGBA colour) {
            this.inverseConduction = inversek;
            this.inverseHeatCapacity = inverseC;
            this.inverseConductionInsulation = insulationInversek;
            this.baseColour = colour;
        }
    }
}

