/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.Tier;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.transmitters.Transmitter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class PartPressurizedTube
extends PartTransmitter<IGasHandler, GasNetwork>
implements IGasHandler {
    public Tier.TubeTier tier = Tier.TubeTier.BASIC;
    public static TransmitterIcons tubeIcons = new TransmitterIcons(4, 8);
    public float currentScale;
    public GasTank buffer = new GasTank(this.getCapacity());
    public GasStack lastWrite;

    public PartPressurizedTube(Tier.TubeTier tubeTier) {
        this.tier = tubeTier;
    }

    @Override
    public void update() {
        if (!this.world().field_72995_K) {
            if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((Transmitter)this.getTransmitter()).getTransmitterNetworkSize() > 0) {
                int last;
                int n = last = this.lastWrite != null ? this.lastWrite.amount : 0;
                if (last != this.getSaveShare()) {
                    MekanismUtils.saveChunk((TileEntity)this.tile());
                }
            }
            IGasHandler[] connectedAcceptors = GasTransmission.getConnectedAcceptors((TileEntity)this.tile());
            for (ForgeDirection side : this.getConnections(PartSidedPipe.ConnectionType.PULL)) {
                GasStack received;
                IGasHandler container;
                if (connectedAcceptors[side.ordinal()] == null || (container = connectedAcceptors[side.ordinal()]) == null || (received = container.drawGas(side.getOpposite(), this.tier.tubePullAmount, false)) == null || received.amount == 0) continue;
                container.drawGas(side.getOpposite(), this.takeGas(received, true), true);
            }
        } else {
            float targetScale;
            float f = targetScale = ((Transmitter)this.getTransmitter()).hasTransmitterNetwork() ? ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).gasScale : (float)this.buffer.getStored() / (float)this.buffer.getMaxGas();
            if ((double)Math.abs(this.currentScale - targetScale) > 0.01) {
                this.currentScale = (9.0f * this.currentScale + targetScale) / 10.0f;
            }
        }
        super.update();
    }

    private int getSaveShare() {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer != null) {
            int remain = ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount % ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.size();
            int toSave = ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount / ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.size();
            if (((IGridTransmitter)((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).transmitters.iterator().next()).equals(this.getTransmitter())) {
                toSave += remain;
            }
            return toSave;
        }
        return 0;
    }

    @Override
    public void onChunkUnload() {
        if (!this.world().field_72995_K && ((Transmitter)this.getTransmitter()).hasTransmitterNetwork() && this.lastWrite != null && ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer != null) {
            ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            if (((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.amount <= 0) {
                ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer = null;
            }
        }
        super.onChunkUnload();
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.tier = Tier.TubeTier.values()[nbtTags.func_74762_e("tier")];
        this.buffer.setMaxGas(this.getCapacity());
        if (nbtTags.func_74764_b("cacheGas")) {
            this.buffer.setGas(GasStack.readFromNBT(nbtTags.func_74775_l("cacheGas")));
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        int toSave = this.getSaveShare();
        if (toSave > 0) {
            GasStack stack;
            this.lastWrite = stack = new GasStack(((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).buffer.getGas(), toSave);
            nbtTags.func_74782_a("cacheGas", (NBTBase)stack.write(new NBTTagCompound()));
        }
    }

    public String getType() {
        return "mekanism:pressurized_tube_" + this.tier.name().toLowerCase();
    }

    public static void registerIcons(IIconRegister register) {
        tubeIcons.registerCenterIcons(register, new String[]{"PressurizedTubeBasic", "PressurizedTubeAdvanced", "PressurizedTubeElite", "PressurizedTubeUltimate"});
        tubeIcons.registerSideIcons(register, new String[]{"SmallTransmitterVerticalBasic", "SmallTransmitterVerticalAdvanced", "SmallTransmitterVerticalElite", "SmallTransmitterVerticalUltimate", "SmallTransmitterHorizontalBasic", "SmallTransmitterHorizontalAdvanced", "SmallTransmitterHorizontalElite", "SmallTransmitterHorizontalUltimate"});
    }

    @Override
    public IIcon getCenterIcon(boolean opaque) {
        return tubeIcons.getCenterIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIcon(boolean opaque) {
        return tubeIcons.getSideIcon(this.tier.ordinal());
    }

    @Override
    public IIcon getSideIconRotated(boolean opaque) {
        return tubeIcons.getSideIcon(4 + this.tier.ordinal());
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public TransmitterType getTransmitterType() {
        return this.tier.type;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, ForgeDirection side) {
        return GasTransmission.canConnect(tile, side);
    }

    @Override
    public GasNetwork createNewNetwork() {
        return new GasNetwork();
    }

    @Override
    public GasNetwork createNetworkByMerging(Collection<GasNetwork> networks) {
        return new GasNetwork(networks);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 0) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    @Override
    public int getCapacity() {
        return this.tier.tubeCapacity;
    }

    @Override
    public GasStack getBuffer() {
        return this.buffer == null ? null : this.buffer.getGas();
    }

    @Override
    public void takeShare() {
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PULL) {
            return this.takeGas(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PULL;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    public int takeGas(GasStack gasStack, boolean doEmit) {
        if (((Transmitter)this.getTransmitter()).hasTransmitterNetwork()) {
            return ((GasNetwork)((Transmitter)this.getTransmitter()).getTransmitterNetwork()).emit(gasStack, doEmit);
        }
        return this.buffer.receive(gasStack, doEmit);
    }

    @Override
    public IGasHandler getCachedAcceptor(ForgeDirection side) {
        if (this.cachedAcceptors[side.ordinal()] instanceof IGasHandler) {
            return (IGasHandler)super.getCachedAcceptor(side);
        }
        return null;
    }
}

