/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityOredictionificator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class PacketEditFilter
implements IMessageHandler<EditFilterMessage, IMessage> {
    public IMessage onMessage(EditFilterMessage message, MessageContext context) {
        block9: {
            WorldServer worldServer;
            block11: {
                block10: {
                    worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
                    if (worldServer == null) break block9;
                    if (message.type != 0 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityLogisticalSorter)) break block10;
                    TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)message.coord4D.getTileEntity((IBlockAccess)worldServer);
                    if (!sorter.filters.contains(message.tFilter)) {
                        return null;
                    }
                    int index = sorter.filters.indexOf(message.tFilter);
                    sorter.filters.remove(index);
                    if (!message.delete) {
                        sorter.filters.add(index, message.tEdited);
                    }
                    for (EntityPlayer iterPlayer : sorter.playersUsing) {
                        Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(sorter), sorter.getFilterPacket(new ArrayList())), (EntityPlayerMP)iterPlayer);
                    }
                    break block9;
                }
                if (message.type != 1 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityDigitalMiner)) break block11;
                TileEntityDigitalMiner miner = (TileEntityDigitalMiner)message.coord4D.getTileEntity((IBlockAccess)worldServer);
                if (!miner.filters.contains(message.mFilter)) {
                    return null;
                }
                int index = miner.filters.indexOf(message.mFilter);
                miner.filters.remove(index);
                if (!message.delete) {
                    miner.filters.add(index, message.mEdited);
                }
                for (EntityPlayer iterPlayer : miner.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(miner), miner.getFilterPacket(new ArrayList())), (EntityPlayerMP)iterPlayer);
                }
                break block9;
            }
            if (message.type != 2 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityOredictionificator)) break block9;
            TileEntityOredictionificator oredictionificator = (TileEntityOredictionificator)message.coord4D.getTileEntity((IBlockAccess)worldServer);
            if (!oredictionificator.filters.contains(message.oFilter)) {
                return null;
            }
            int index = oredictionificator.filters.indexOf(message.oFilter);
            oredictionificator.filters.remove(index);
            if (!message.delete) {
                oredictionificator.filters.add(index, message.oEdited);
            }
            for (EntityPlayer iterPlayer : oredictionificator.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(oredictionificator), oredictionificator.getFilterPacket(new ArrayList())), (EntityPlayerMP)iterPlayer);
            }
        }
        return null;
    }

    public static class EditFilterMessage
    implements IMessage {
        public Coord4D coord4D;
        public TransporterFilter tFilter;
        public TransporterFilter tEdited;
        public MinerFilter mFilter;
        public MinerFilter mEdited;
        public TileEntityOredictionificator.OredictionificatorFilter oFilter;
        public TileEntityOredictionificator.OredictionificatorFilter oEdited;
        public byte type = (byte)-1;
        public boolean delete;

        public EditFilterMessage() {
        }

        public EditFilterMessage(Coord4D coord, boolean deletion, Object filter, Object edited) {
            this.coord4D = coord;
            this.delete = deletion;
            if (filter instanceof TransporterFilter) {
                this.tFilter = (TransporterFilter)filter;
                if (!this.delete) {
                    this.tEdited = (TransporterFilter)edited;
                }
                this.type = 0;
            } else if (filter instanceof MinerFilter) {
                this.mFilter = (MinerFilter)filter;
                if (!this.delete) {
                    this.mEdited = (MinerFilter)edited;
                }
                this.type = 1;
            } else if (filter instanceof TileEntityOredictionificator.OredictionificatorFilter) {
                this.oFilter = (TileEntityOredictionificator.OredictionificatorFilter)filter;
                if (!this.delete) {
                    this.oEdited = (TileEntityOredictionificator.OredictionificatorFilter)edited;
                }
                this.type = (byte)2;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.coord4D.xCoord);
            dataStream.writeInt(this.coord4D.yCoord);
            dataStream.writeInt(this.coord4D.zCoord);
            dataStream.writeInt(this.coord4D.dimensionId);
            dataStream.writeByte((int)this.type);
            dataStream.writeBoolean(this.delete);
            ArrayList data = new ArrayList();
            if (this.type == 0) {
                this.tFilter.write(data);
                if (!this.delete) {
                    this.tEdited.write(data);
                }
            } else if (this.type == 1) {
                this.mFilter.write(data);
                if (!this.delete) {
                    this.mEdited.write(data);
                }
            } else if (this.type == 2) {
                this.oFilter.write(data);
                if (!this.delete) {
                    this.oEdited.write(data);
                }
            }
            PacketHandler.encode(data.toArray(), dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.type = dataStream.readByte();
            this.delete = dataStream.readBoolean();
            if (this.type == 0) {
                this.tFilter = TransporterFilter.readFromPacket(dataStream);
                if (!this.delete) {
                    this.tEdited = TransporterFilter.readFromPacket(dataStream);
                }
            } else if (this.type == 1) {
                this.mFilter = MinerFilter.readFromPacket(dataStream);
                if (!this.delete) {
                    this.mEdited = MinerFilter.readFromPacket(dataStream);
                }
            } else if (this.type == 2) {
                this.oFilter = TileEntityOredictionificator.OredictionificatorFilter.readFromPacket(dataStream);
                if (!this.delete) {
                    this.oEdited = TileEntityOredictionificator.OredictionificatorFilter.readFromPacket(dataStream);
                }
            }
        }
    }
}

