/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.content.boiler.BoilerCache;
import mekanism.common.content.boiler.BoilerUpdateProtocol;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.HeatUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class TileEntityBoiler
extends TileEntityMultiblock<SynchronizedBoilerData>
implements IFluidContainerManager,
IHeatTransfer {
    public Map<SynchronizedBoilerData.ValveData, Integer> valveViewing = new HashMap<SynchronizedBoilerData.ValveData, Integer>();
    public int clientWaterCapacity;
    public int clientSteamCapacity;
    public float prevWaterScale;
    public float prevSteamScale;
    public ForgeDirection innerSide;
    public double temperature;
    public double heatToAbsorb;
    public double invHeatCapacity = 5.0;

    public TileEntityBoiler() {
        this("SteamBoiler");
    }

    public TileEntityBoiler(String name) {
        super(name);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            if (this.structure != null && this.clientHasStructure && this.isRendering) {
                for (SynchronizedBoilerData.ValveData data : this.valveViewing.keySet()) {
                    if (this.valveViewing.get(data) <= 0) continue;
                    this.valveViewing.put(data, this.valveViewing.get(data) - 1);
                }
                float targetScale = (float)(((SynchronizedBoilerData)this.structure).waterStored != null ? ((SynchronizedBoilerData)this.structure).waterStored.amount : 0) / (float)this.clientWaterCapacity;
                if ((double)Math.abs(this.prevWaterScale - targetScale) > 0.01) {
                    this.prevWaterScale = (9.0f * this.prevWaterScale + targetScale) / 10.0f;
                }
                if ((double)Math.abs(this.prevSteamScale - (targetScale = (float)(((SynchronizedBoilerData)this.structure).steamStored != null ? ((SynchronizedBoilerData)this.structure).steamStored.amount : 0) / (float)this.clientSteamCapacity)) > 0.01) {
                    this.prevSteamScale = (9.0f * this.prevSteamScale + targetScale) / 10.0f;
                }
            }
            if (!this.clientHasStructure || !this.isRendering) {
                for (SynchronizedBoilerData.ValveData data : this.valveViewing.keySet()) {
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            this.manageInventory();
        }
    }

    public void manageInventory() {
        int max = ((SynchronizedBoilerData)this.structure).volume * 16000;
        if (((SynchronizedBoilerData)this.structure).inventory[0] != null) {
            if (((SynchronizedBoilerData)this.structure).inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                if (((SynchronizedBoilerData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.FILL && ((SynchronizedBoilerData)this.structure).waterStored != null) {
                    int prev = ((SynchronizedBoilerData)this.structure).waterStored.amount;
                    ((SynchronizedBoilerData)this.structure).waterStored.amount -= FluidContainerUtils.insertFluid(((SynchronizedBoilerData)this.structure).waterStored, ((SynchronizedBoilerData)this.structure).inventory[0]);
                    if ((prev == ((SynchronizedBoilerData)this.structure).waterStored.amount || ((SynchronizedBoilerData)this.structure).waterStored.amount == 0) && ((SynchronizedBoilerData)this.structure).inventory[1] == null) {
                        ((SynchronizedBoilerData)this.structure).inventory[1] = ((SynchronizedBoilerData)this.structure).inventory[0].func_77946_l();
                        ((SynchronizedBoilerData)this.structure).inventory[0] = null;
                        this.func_70296_d();
                    }
                    if (((SynchronizedBoilerData)this.structure).waterStored.amount == 0) {
                        ((SynchronizedBoilerData)this.structure).waterStored = null;
                    }
                } else if (((SynchronizedBoilerData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.EMPTY) {
                    int newStored;
                    if (((SynchronizedBoilerData)this.structure).waterStored != null) {
                        FluidStack received = FluidContainerUtils.extractFluid(max - ((SynchronizedBoilerData)this.structure).waterStored.amount, ((SynchronizedBoilerData)this.structure).inventory[0], ((SynchronizedBoilerData)this.structure).waterStored.getFluid());
                        if (received != null) {
                            ((SynchronizedBoilerData)this.structure).waterStored.amount += received.amount;
                        }
                    } else {
                        ((SynchronizedBoilerData)this.structure).waterStored = FluidContainerUtils.extractFluid(max, ((SynchronizedBoilerData)this.structure).inventory[0], null);
                    }
                    int n = newStored = ((SynchronizedBoilerData)this.structure).waterStored != null ? ((SynchronizedBoilerData)this.structure).waterStored.amount : 0;
                    if ((((IFluidContainerItem)((SynchronizedBoilerData)this.structure).inventory[0].func_77973_b()).getFluid(((SynchronizedBoilerData)this.structure).inventory[0]) == null || newStored == max) && ((SynchronizedBoilerData)this.structure).inventory[1] == null) {
                        ((SynchronizedBoilerData)this.structure).inventory[1] = ((SynchronizedBoilerData)this.structure).inventory[0].func_77946_l();
                        ((SynchronizedBoilerData)this.structure).inventory[0] = null;
                        this.func_70296_d();
                    }
                }
            } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)((SynchronizedBoilerData)this.structure).inventory[0]) && (((SynchronizedBoilerData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.BOTH || ((SynchronizedBoilerData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.FILL)) {
                ItemStack filled;
                if (((SynchronizedBoilerData)this.structure).waterStored != null && ((SynchronizedBoilerData)this.structure).waterStored.amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)((SynchronizedBoilerData)this.structure).waterStored, (ItemStack)((SynchronizedBoilerData)this.structure).inventory[0])) != null && (((SynchronizedBoilerData)this.structure).inventory[1] == null || ((SynchronizedBoilerData)this.structure).inventory[1].func_77969_a(filled) && ((SynchronizedBoilerData)this.structure).inventory[1].field_77994_a + 1 <= filled.func_77976_d())) {
                    --((SynchronizedBoilerData)this.structure).inventory[0].field_77994_a;
                    if (((SynchronizedBoilerData)this.structure).inventory[0].field_77994_a <= 0) {
                        ((SynchronizedBoilerData)this.structure).inventory[0] = null;
                    }
                    if (((SynchronizedBoilerData)this.structure).inventory[1] == null) {
                        ((SynchronizedBoilerData)this.structure).inventory[1] = filled;
                    } else {
                        ++((SynchronizedBoilerData)this.structure).inventory[1].field_77994_a;
                    }
                    this.func_70296_d();
                    ((SynchronizedBoilerData)this.structure).waterStored.amount -= FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount;
                    if (((SynchronizedBoilerData)this.structure).waterStored.amount == 0) {
                        ((SynchronizedBoilerData)this.structure).waterStored = null;
                    }
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)((SynchronizedBoilerData)this.structure).inventory[0]) && (((SynchronizedBoilerData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.BOTH || ((SynchronizedBoilerData)this.structure).editMode == FluidContainerUtils.ContainerEditMode.EMPTY)) {
                FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((SynchronizedBoilerData)this.structure).inventory[0]);
                if (((SynchronizedBoilerData)this.structure).waterStored == null && itemFluid.amount <= max || ((SynchronizedBoilerData)this.structure).waterStored.amount + itemFluid.amount <= max) {
                    if (((SynchronizedBoilerData)this.structure).waterStored != null && !((SynchronizedBoilerData)this.structure).waterStored.isFluidEqual(itemFluid)) {
                        return;
                    }
                    ItemStack containerItem = ((SynchronizedBoilerData)this.structure).inventory[0].func_77973_b().getContainerItem(((SynchronizedBoilerData)this.structure).inventory[0]);
                    boolean filled = false;
                    if (containerItem != null) {
                        if (((SynchronizedBoilerData)this.structure).inventory[1] == null || ((SynchronizedBoilerData)this.structure).inventory[1].func_77969_a(containerItem) && ((SynchronizedBoilerData)this.structure).inventory[1].field_77994_a + 1 <= containerItem.func_77976_d()) {
                            ((SynchronizedBoilerData)this.structure).inventory[0] = null;
                            if (((SynchronizedBoilerData)this.structure).inventory[1] == null) {
                                ((SynchronizedBoilerData)this.structure).inventory[1] = containerItem;
                            } else {
                                ++((SynchronizedBoilerData)this.structure).inventory[1].field_77994_a;
                            }
                            filled = true;
                        }
                    } else {
                        --((SynchronizedBoilerData)this.structure).inventory[0].field_77994_a;
                        if (((SynchronizedBoilerData)this.structure).inventory[0].field_77994_a == 0) {
                            ((SynchronizedBoilerData)this.structure).inventory[0] = null;
                        }
                        filled = true;
                    }
                    if (filled) {
                        if (((SynchronizedBoilerData)this.structure).waterStored == null) {
                            ((SynchronizedBoilerData)this.structure).waterStored = itemFluid.copy();
                        } else {
                            ((SynchronizedBoilerData)this.structure).waterStored.amount += itemFluid.amount;
                        }
                        this.func_70296_d();
                    }
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
        }
    }

    @Override
    protected SynchronizedBoilerData getNewStructure() {
        return new SynchronizedBoilerData();
    }

    public BoilerCache getNewCache() {
        return new BoilerCache();
    }

    protected BoilerUpdateProtocol getProtocol() {
        return new BoilerUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedBoilerData> getManager() {
        return Mekanism.boilerManager;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedBoilerData)this.structure).volume * 16000);
            data.add(((SynchronizedBoilerData)this.structure).volume * 160000);
            data.add(((SynchronizedBoilerData)this.structure).editMode.ordinal());
        }
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).waterStored != null) {
            data.add(1);
            data.add(((SynchronizedBoilerData)this.structure).waterStored.getFluidID());
            data.add(((SynchronizedBoilerData)this.structure).waterStored.amount);
        } else {
            data.add(0);
        }
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).steamStored != null) {
            data.add(1);
            data.add(((SynchronizedBoilerData)this.structure).steamStored.getFluidID());
            data.add(((SynchronizedBoilerData)this.structure).steamStored.amount);
        } else {
            data.add(0);
        }
        if (this.structure != null && this.isRendering) {
            data.add(((SynchronizedBoilerData)this.structure).valves.size());
            for (SynchronizedBoilerData.ValveData valveData : ((SynchronizedBoilerData)this.structure).valves) {
                valveData.location.write(data);
                data.add(valveData.side.ordinal());
                data.add(valveData.serverFluid);
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.clientHasStructure) {
            this.clientWaterCapacity = dataStream.readInt();
            this.clientSteamCapacity = dataStream.readInt();
            ((SynchronizedBoilerData)this.structure).editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
        }
        ((SynchronizedBoilerData)this.structure).waterStored = dataStream.readInt() == 1 ? new FluidStack(dataStream.readInt(), dataStream.readInt()) : null;
        ((SynchronizedBoilerData)this.structure).steamStored = dataStream.readInt() == 1 ? new FluidStack(dataStream.readInt(), dataStream.readInt()) : null;
        if (this.clientHasStructure && this.isRendering) {
            int size = dataStream.readInt();
            for (int i = 0; i < size; ++i) {
                SynchronizedBoilerData.ValveData data = new SynchronizedBoilerData.ValveData();
                data.location = Coord4D.read(dataStream);
                data.side = ForgeDirection.getOrientation((int)dataStream.readInt());
                int viewingTicks = 0;
                if (dataStream.readBoolean()) {
                    viewingTicks = 30;
                }
                if (viewingTicks == 0 && this.valveViewing.containsKey(data) && this.valveViewing.get(data) > 0) continue;
                this.valveViewing.put(data, viewingTicks);
                TileEntityBoiler tileEntity = (TileEntityBoiler)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity == null) continue;
                tileEntity.clientHasStructure = true;
            }
        }
    }

    public int getScaledWaterLevel(int i) {
        if (this.clientWaterCapacity == 0 || ((SynchronizedBoilerData)this.structure).waterStored == null) {
            return 0;
        }
        return ((SynchronizedBoilerData)this.structure).waterStored.amount * i / this.clientWaterCapacity;
    }

    public int getScaledSteamLevel(int i) {
        if (this.clientSteamCapacity == 0 || ((SynchronizedBoilerData)this.structure).steamStored == null) {
            return 0;
        }
        return ((SynchronizedBoilerData)this.structure).steamStored.amount * i / this.clientSteamCapacity;
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        if (this.structure != null) {
            return ((SynchronizedBoilerData)this.structure).editMode;
        }
        return FluidContainerUtils.ContainerEditMode.BOTH;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        if (this.structure == null) {
            return;
        }
        ((SynchronizedBoilerData)this.structure).editMode = mode;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 50.0;
    }

    @Override
    public double getInsulationCoefficient(ForgeDirection side) {
        return 50.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        this.innerSide = null;
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.invHeatCapacity * this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(ForgeDirection side) {
        return this.structure == null || !this.isInnerSide(side);
    }

    @Override
    public IHeatTransfer getAdjacent(ForgeDirection side) {
        if (this.structure != null && this.isInnerSide(side)) {
            return (IHeatTransfer)((Object)this.structure);
        }
        TileEntity adj = Coord4D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (adj instanceof IHeatTransfer) {
            return (IHeatTransfer)adj;
        }
        return null;
    }

    public boolean isInnerSide(ForgeDirection side) {
        if (this.innerSide != null) {
            return side == this.innerSide;
        }
        if (!Coord4D.get(this).getFromSide(side).getBlock((IBlockAccess)this.field_145850_b).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return false;
        }
        if (this.structure == null || ((SynchronizedBoilerData)this.structure).minLocation == null || ((SynchronizedBoilerData)this.structure).maxLocation == null) {
            return false;
        }
        switch (side) {
            case DOWN: {
                return this.field_145848_d == ((SynchronizedBoilerData)this.structure).maxLocation.yCoord;
            }
            case UP: {
                return this.field_145848_d == ((SynchronizedBoilerData)this.structure).minLocation.yCoord;
            }
            case NORTH: {
                return this.field_145849_e == ((SynchronizedBoilerData)this.structure).maxLocation.zCoord;
            }
            case SOUTH: {
                return this.field_145849_e == ((SynchronizedBoilerData)this.structure).minLocation.zCoord;
            }
            case WEST: {
                return this.field_145851_c == ((SynchronizedBoilerData)this.structure).maxLocation.xCoord;
            }
            case EAST: {
                return this.field_145851_c == ((SynchronizedBoilerData)this.structure).minLocation.xCoord;
            }
        }
        return false;
    }
}

