/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.base.ITileNetwork;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityBoundingBlock
extends TileEntity
implements ITileNetwork {
    public int mainX;
    public int mainY;
    public int mainZ;
    public boolean receivedCoords;
    public boolean prevPower;

    public void setMainLocation(int x, int y, int z) {
        this.receivedCoords = true;
        if (!this.field_145850_b.field_72995_K) {
            this.mainX = x;
            this.mainY = y;
            this.mainZ = z;
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get(this)));
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void onNeighborChange(Block block) {
        TileEntity tile = this.field_145850_b.func_147438_o(this.mainX, this.mainY, this.mainZ);
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)tile;
            boolean power = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.prevPower != power) {
                if (power) {
                    this.onPower();
                } else {
                    this.onNoPower();
                }
                this.prevPower = power;
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            }
        }
    }

    public void onPower() {
    }

    public void onNoPower() {
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        this.mainX = dataStream.readInt();
        this.mainY = dataStream.readInt();
        this.mainZ = dataStream.readInt();
        this.prevPower = dataStream.readBoolean();
    }

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.mainX = nbtTags.func_74762_e("mainX");
        this.mainY = nbtTags.func_74762_e("mainY");
        this.mainZ = nbtTags.func_74762_e("mainZ");
        this.prevPower = nbtTags.func_74767_n("prevPower");
        this.receivedCoords = nbtTags.func_74767_n("receivedCoords");
    }

    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("mainX", this.mainX);
        nbtTags.func_74768_a("mainY", this.mainY);
        nbtTags.func_74768_a("mainZ", this.mainZ);
        nbtTags.func_74757_a("prevPower", this.prevPower);
        nbtTags.func_74757_a("receivedCoords", this.receivedCoords);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.mainX);
        data.add(this.mainY);
        data.add(this.mainZ);
        data.add(this.prevPower);
        return data;
    }
}

