/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntitySolarEvaporationController;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySolarEvaporationBlock
extends TileEntityContainerBlock {
    public TileEntitySolarEvaporationController master;
    public boolean attempted;

    public TileEntitySolarEvaporationBlock() {
        super("SolarEvaporationBlock");
        this.inventory = new ItemStack[0];
    }

    public TileEntitySolarEvaporationBlock(String fullName) {
        super(fullName);
        this.inventory = new ItemStack[0];
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K && this.ticker == 5 && !this.attempted && this.master == null) {
            this.updateController();
        }
        this.attempted = false;
    }

    public void addToStructure(TileEntitySolarEvaporationController controller) {
        this.master = controller;
    }

    public void controllerGone() {
        this.master = null;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.master != null) {
            this.master.refresh();
        }
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        if (!this.field_145850_b.field_72995_K) {
            if (this.master != null) {
                this.master.refresh();
            } else {
                this.updateController();
            }
        }
    }

    public void updateController() {
        TileEntitySolarEvaporationController found;
        if (!(this instanceof TileEntitySolarEvaporationController) && (found = new ControllerFinder().find()) != null) {
            found.refresh();
        }
    }

    public class ControllerFinder {
        public TileEntitySolarEvaporationController found;
        public Set<Coord4D> iterated = new HashSet<Coord4D>();

        public void loop(Coord4D pos) {
            if (this.iterated.size() > 512 || this.found != null) {
                return;
            }
            this.iterated.add(pos);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Coord4D coord = pos.getFromSide(side);
                if (this.iterated.contains(coord) || !(coord.getTileEntity((IBlockAccess)TileEntitySolarEvaporationBlock.this.field_145850_b) instanceof TileEntitySolarEvaporationBlock)) continue;
                ((TileEntitySolarEvaporationBlock)coord.getTileEntity((IBlockAccess)((TileEntitySolarEvaporationBlock)TileEntitySolarEvaporationBlock.this).field_145850_b)).attempted = true;
                if (coord.getTileEntity((IBlockAccess)TileEntitySolarEvaporationBlock.this.field_145850_b) instanceof TileEntitySolarEvaporationController) {
                    this.found = (TileEntitySolarEvaporationController)coord.getTileEntity((IBlockAccess)TileEntitySolarEvaporationBlock.this.field_145850_b);
                    return;
                }
                this.loop(coord);
            }
        }

        public TileEntitySolarEvaporationController find() {
            this.loop(Coord4D.get(TileEntitySolarEvaporationBlock.this));
            return this.found;
        }
    }
}

