/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import mekanism.api.EnumColor;
import mekanism.api.util.StackUtils;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.MekanismUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.util.ForgeDirection;

public final class InventoryUtils {
    public static final int[] EMPTY = new int[0];

    public static int[] getIntRange(int start, int end) {
        int[] ret = new int[1 + end - start];
        for (int i = start; i <= end; ++i) {
            ret[i - start] = i;
        }
        return ret;
    }

    public static IInventory checkChestInv(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest main = (TileEntityChest)inv;
            TileEntityChest adj = null;
            if (main.field_145991_k != null) {
                adj = main.field_145991_k;
            } else if (main.field_145990_j != null) {
                adj = main.field_145990_j;
            } else if (main.field_145992_i != null) {
                adj = main.field_145992_i;
            } else if (main.field_145988_l != null) {
                adj = main.field_145988_l;
            }
            if (adj != null) {
                return new InventoryLargeChest("", (IInventory)main, (IInventory)adj);
            }
        }
        return inv;
    }

    public static ItemStack putStackInInventory(IInventory inventory, ItemStack itemStack, int side, boolean force) {
        ItemStack toInsert;
        block9: {
            block8: {
                inventory = InventoryUtils.checkChestInv(inventory);
                if (force && inventory instanceof TileEntityLogisticalSorter) {
                    return ((TileEntityLogisticalSorter)inventory).sendHome(itemStack.func_77946_l());
                }
                toInsert = itemStack.func_77946_l();
                if (inventory instanceof ISidedInventory) break block8;
                for (int i = 0; i <= inventory.func_70302_i_() - 1; ++i) {
                    if (!force && !inventory.func_94041_b(i, toInsert)) continue;
                    ItemStack inSlot = inventory.func_70301_a(i);
                    if (inSlot == null) {
                        inventory.func_70299_a(i, toInsert);
                        inventory.func_70296_d();
                        return null;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= inSlot.func_77976_d() || inSlot.field_77994_a >= inventory.func_70297_j_()) continue;
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= inSlot.func_77976_d()) {
                        ItemStack toSet = toInsert.func_77946_l();
                        toSet.field_77994_a += inSlot.field_77994_a;
                        inventory.func_70299_a(i, toSet);
                        inventory.func_70296_d();
                        return null;
                    }
                    int rejects = inSlot.field_77994_a + toInsert.field_77994_a - inSlot.func_77976_d();
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.field_77994_a = inSlot.func_77976_d();
                    ItemStack remains = toInsert.func_77946_l();
                    remains.field_77994_a = rejects;
                    inventory.func_70299_a(i, toSet);
                    inventory.func_70296_d();
                    toInsert = remains;
                }
                break block9;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.OPPOSITES[side]);
            if (slots == null || slots.length == 0) break block9;
            if (force && sidedInventory instanceof TileEntityBin && ForgeDirection.OPPOSITES[side] == 0) {
                slots = sidedInventory.func_94128_d(1);
            }
            for (int get = 0; get <= slots.length - 1; ++get) {
                int slotID = slots[get];
                if (!force && (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_102007_a(slotID, toInsert, ForgeDirection.OPPOSITES[side]))) continue;
                ItemStack inSlot = inventory.func_70301_a(slotID);
                if (inSlot == null) {
                    inventory.func_70299_a(slotID, toInsert);
                    inventory.func_70296_d();
                    return null;
                }
                if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= inSlot.func_77976_d() || inSlot.field_77994_a >= inventory.func_70297_j_()) continue;
                if (inSlot.field_77994_a + toInsert.field_77994_a <= inSlot.func_77976_d()) {
                    ItemStack toSet = toInsert.func_77946_l();
                    toSet.field_77994_a += inSlot.field_77994_a;
                    inventory.func_70299_a(slotID, toSet);
                    inventory.func_70296_d();
                    return null;
                }
                int rejects = inSlot.field_77994_a + toInsert.field_77994_a - inSlot.func_77976_d();
                ItemStack toSet = toInsert.func_77946_l();
                toSet.field_77994_a = inSlot.func_77976_d();
                ItemStack remains = toInsert.func_77946_l();
                remains.field_77994_a = rejects;
                inventory.func_70299_a(slotID, toSet);
                inventory.func_70296_d();
                toInsert = remains;
            }
        }
        return toInsert;
    }

    public static boolean areItemsStackable(ItemStack toInsert, ItemStack inSlot) {
        return inSlot.func_77969_a(toInsert) && ItemStack.func_77970_a((ItemStack)inSlot, (ItemStack)toInsert);
    }

    public static InvStack takeTopItem(IInventory inventory, int side, int amount) {
        block3: {
            block2: {
                if ((inventory = InventoryUtils.checkChestInv(inventory)) instanceof ISidedInventory) break block2;
                for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                    if (inventory.func_70301_a(i) == null || inventory.func_70301_a((int)i).field_77994_a <= 0) continue;
                    ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
                    toSend.field_77994_a = Math.min(amount, toSend.field_77994_a);
                    return new InvStack(inventory, i, toSend);
                }
                break block3;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.OPPOSITES[side]);
            if (slots == null) break block3;
            for (int get = slots.length - 1; get >= 0; --get) {
                int slotID = slots[get];
                if (sidedInventory.func_70301_a(slotID) == null || sidedInventory.func_70301_a((int)slotID).field_77994_a <= 0) continue;
                ItemStack toSend = sidedInventory.func_70301_a(slotID).func_77946_l();
                toSend.field_77994_a = Math.min(amount, toSend.field_77994_a);
                if (!sidedInventory.func_102008_b(slotID, toSend, ForgeDirection.OPPOSITES[side])) continue;
                return new InvStack(inventory, slotID, toSend);
            }
        }
        return null;
    }

    public static InvStack takeDefinedItem(IInventory inventory, int side, ItemStack type, int min, int max) {
        inventory = InventoryUtils.checkChestInv(inventory);
        InvStack ret = new InvStack(inventory);
        if (!(inventory instanceof ISidedInventory)) {
            for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                int current;
                if (inventory.func_70301_a(i) == null || !StackUtils.equalsWildcard(inventory.func_70301_a(i), type)) continue;
                ItemStack stack = inventory.func_70301_a(i);
                int n = current = ret.getStack() != null ? ret.getStack().field_77994_a : 0;
                if (current + stack.field_77994_a <= max) {
                    ret.appendStack(i, stack.func_77946_l());
                } else {
                    ItemStack copy = stack.func_77946_l();
                    copy.field_77994_a = max - current;
                    ret.appendStack(i, copy);
                }
                if (ret.getStack() == null || ret.getStack().field_77994_a != max) continue;
                return ret;
            }
        } else {
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.OPPOSITES[side]);
            if (slots != null && slots.length != 0) {
                for (int get = slots.length - 1; get >= 0; --get) {
                    ItemStack copy;
                    int current;
                    int slotID = slots[get];
                    if (sidedInventory.func_70301_a(slotID) == null || !StackUtils.equalsWildcard(inventory.func_70301_a(slotID), type)) continue;
                    ItemStack stack = sidedInventory.func_70301_a(slotID);
                    int n = current = ret.getStack() != null ? ret.getStack().field_77994_a : 0;
                    if (current + stack.field_77994_a <= max) {
                        copy = stack.func_77946_l();
                        if (sidedInventory.func_102008_b(slotID, copy, ForgeDirection.OPPOSITES[side])) {
                            ret.appendStack(slotID, copy);
                        }
                    } else {
                        copy = stack.func_77946_l();
                        if (sidedInventory.func_102008_b(slotID, copy, ForgeDirection.OPPOSITES[side])) {
                            copy.field_77994_a = max - current;
                            ret.appendStack(slotID, copy);
                        }
                    }
                    if (ret.getStack() == null || ret.getStack().field_77994_a != max) continue;
                    return ret;
                }
            }
        }
        if (ret != null && ret.getStack() != null && ret.getStack().field_77994_a >= min) {
            return ret;
        }
        return null;
    }

    public static InvStack takeTopStack(IInventory inventory, int side, Finder id) {
        block3: {
            block2: {
                if ((inventory = InventoryUtils.checkChestInv(inventory)) instanceof ISidedInventory) break block2;
                for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                    if (inventory.func_70301_a(i) == null || !id.modifies(inventory.func_70301_a(i))) continue;
                    ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
                    return new InvStack(inventory, i, toSend);
                }
                break block3;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.OPPOSITES[side]);
            if (slots == null || slots.length == 0) break block3;
            for (int get = slots.length - 1; get >= 0; --get) {
                ItemStack toSend;
                int slotID = slots[get];
                if (sidedInventory.func_70301_a(slotID) == null || !id.modifies(sidedInventory.func_70301_a(slotID)) || !sidedInventory.func_102008_b(slotID, toSend = sidedInventory.func_70301_a(slotID), ForgeDirection.OPPOSITES[side])) continue;
                return new InvStack(inventory, slotID, toSend);
            }
        }
        return null;
    }

    public static boolean canInsert(TileEntity tileEntity, EnumColor color, ItemStack itemStack, int side, boolean force) {
        block12: {
            IInventory inventory;
            block11: {
                if (!(tileEntity instanceof IInventory)) {
                    return false;
                }
                if (force && tileEntity instanceof TileEntityLogisticalSorter) {
                    return ((TileEntityLogisticalSorter)tileEntity).canSendHome(itemStack);
                }
                if (!force && tileEntity instanceof ISideConfiguration) {
                    ISideConfiguration config = (ISideConfiguration)tileEntity;
                    int tileSide = config.getOrientation();
                    EnumColor configColor = config.getEjector().getInputColor(ForgeDirection.getOrientation((int)MekanismUtils.getBaseOrientation(side, tileSide)).getOpposite());
                    if (config.getEjector().hasStrictInput() && configColor != null && configColor != color) {
                        return false;
                    }
                }
                if ((inventory = InventoryUtils.checkChestInv((IInventory)tileEntity)) instanceof ISidedInventory) break block11;
                for (int i = 0; i <= inventory.func_70302_i_() - 1; ++i) {
                    if (!force && !inventory.func_94041_b(i, itemStack)) continue;
                    ItemStack inSlot = inventory.func_70301_a(i);
                    if (inSlot == null) {
                        return true;
                    }
                    if (!InventoryUtils.areItemsStackable(itemStack, inSlot) || inSlot.field_77994_a >= inSlot.func_77976_d() || inSlot.field_77994_a >= inventory.func_70297_j_()) continue;
                    if (inSlot.field_77994_a + itemStack.field_77994_a <= inSlot.func_77976_d()) {
                        return true;
                    }
                    int rejects = inSlot.field_77994_a + itemStack.field_77994_a - inSlot.func_77976_d();
                    if (rejects >= itemStack.field_77994_a) continue;
                    return true;
                }
                break block12;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.OPPOSITES[side]);
            if (slots == null || slots.length == 0) break block12;
            if (force && sidedInventory instanceof TileEntityBin && ForgeDirection.OPPOSITES[side] == 0) {
                slots = sidedInventory.func_94128_d(1);
            }
            for (int get = 0; get <= slots.length - 1; ++get) {
                int slotID = slots[get];
                if (!force && (!sidedInventory.func_94041_b(slotID, itemStack) || !sidedInventory.func_102007_a(slotID, itemStack, ForgeDirection.OPPOSITES[side]))) continue;
                ItemStack inSlot = inventory.func_70301_a(slotID);
                if (inSlot == null) {
                    return true;
                }
                if (!InventoryUtils.areItemsStackable(itemStack, inSlot) || inSlot.field_77994_a >= inSlot.func_77976_d() || inSlot.field_77994_a >= inventory.func_70297_j_()) continue;
                if (inSlot.field_77994_a + itemStack.field_77994_a <= inSlot.func_77976_d()) {
                    return true;
                }
                int rejects = inSlot.field_77994_a + itemStack.field_77994_a - inSlot.func_77976_d();
                if (rejects >= itemStack.field_77994_a) continue;
                return true;
            }
        }
        return false;
    }
}

