/*
 * Decompiled with CFR 0.152.
 */
package mapwriter;

import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import mapwriter.MwUtil;
import mapwriter.tasks.Task;

public class BackgroundExecutor {
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private LinkedList<Task> taskQueue = new LinkedList();
    public boolean closed = false;

    public boolean addTask(Task task) {
        if (!this.closed) {
            Future<?> future = this.executor.submit(task);
            task.setFuture(future);
            this.taskQueue.add(task);
        } else {
            MwUtil.log("MwExecutor.addTask: error: cannot add task to closed executor", new Object[0]);
        }
        return this.closed;
    }

    public boolean processTaskQueue() {
        boolean processed = false;
        Task task = this.taskQueue.poll();
        if (task != null) {
            if (task.isDone()) {
                task.printException();
                task.onComplete();
                processed = true;
            } else {
                this.taskQueue.push(task);
            }
        }
        return !processed;
    }

    public boolean processRemainingTasks(int attempts, int delay) {
        while (this.taskQueue.size() > 0 && attempts > 0) {
            if (!this.processTaskQueue()) continue;
            try {
                Thread.sleep(delay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            --attempts;
        }
        return attempts <= 0;
    }

    public int tasksRemaining() {
        return this.taskQueue.size();
    }

    public boolean close() {
        boolean error = true;
        try {
            this.executor.shutdown();
            this.processRemainingTasks(50, 5);
            error = !this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            error = false;
        }
        catch (InterruptedException e) {
            MwUtil.log("error: IO task was interrupted during shutdown", new Object[0]);
            e.printStackTrace();
        }
        this.closed = true;
        return error;
    }
}

