/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.rain.tick;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import dmillerw.rain.TooMuchRain;
import dmillerw.rain.util.NumberUtil;
import java.util.Random;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.config.Configuration;

public class WorldTicker {
    public static final int RAIN_DURATION_CONSTANT = 12000;
    public static final int RAIN_DURATION_MODULATOR = 12000;
    public static final int RAIN_BREAK_CONSTANT = 12000;
    public static final int RAIN_BREAK_MODULATOR = 168000;
    public static final int THUNDER_DURATION_CONSTANT = 3600;
    public static final int THUNDER_DURATION_MODULATOR = 12000;
    public static final int THUNDER_BREAK_CONSTANT = 12000;
    public static final int THUNDER_BREAK_MODULATOR = 168000;
    public static final Random random = new Random();
    private int lastRainTick = 0;
    private boolean lastRainState = false;
    private int lastThunderTick = 0;
    private boolean lastThunderState = false;

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            WorldServer world = (WorldServer)event.world;
            WorldInfo info = world.func_72912_H();
            if (!world.field_73011_w.field_76576_e) {
                this.tickRain(info, TooMuchRain.settings);
                this.tickThunder(info, TooMuchRain.settings);
            }
        }
    }

    private void tickRain(WorldInfo info, ConfigWrapper config) {
        int rainTick = info.func_76083_p();
        boolean rainState = info.func_76059_o();
        if (this.lastRainTick != 0 && !NumberUtil.inRange(this.lastRainTick, rainTick, 10)) {
            this.recalculateRainTicks(info, config);
        }
        this.lastRainTick = rainTick;
        if (rainState != this.lastRainState) {
            this.recalculateRainTicks(info, config);
            this.lastRainState = rainState;
        }
    }

    private void tickThunder(WorldInfo info, ConfigWrapper config) {
        int thunderTick = info.func_76083_p();
        boolean thunderState = info.func_76059_o();
        if (this.lastThunderTick != 0 && !NumberUtil.inRange(this.lastThunderTick, thunderTick, 10)) {
            this.recalculateThunderTicks(info, config);
        }
        this.lastThunderTick = thunderTick;
        if (thunderState != this.lastThunderState) {
            this.recalculateThunderTicks(info, config);
            this.lastThunderState = thunderState;
        }
    }

    private void recalculateRainTicks(WorldInfo info, ConfigWrapper config) {
        if (!info.func_76059_o()) {
            info.func_76080_g(random.nextInt(config.rainBreakModulator + 1) + config.rainBreakConstant);
        } else {
            info.func_76080_g(random.nextInt(config.rainDurationModulator + 1) + config.rainDurationConstant);
        }
    }

    private void recalculateThunderTicks(WorldInfo info, ConfigWrapper config) {
        if (!info.func_76061_m()) {
            info.func_76090_f(random.nextInt(config.thunderBreakModulator + 1) + config.thunderBreakConstant);
        } else {
            info.func_76090_f(random.nextInt(config.thunderDurationModulator + 1) + config.thunderDurationModulator);
        }
    }

    public static class ConfigWrapper {
        public int rainDurationConstant = 0;
        public int rainDurationModulator = 0;
        public int rainBreakConstant = 0;
        public int rainBreakModulator = 0;
        public int thunderDurationConstant = 0;
        public int thunderDurationModulator = 0;
        public int thunderBreakConstant = 0;
        public int thunderBreakModulator = 0;

        public ConfigWrapper fromConfig(Configuration configuration) {
            this.rainDurationConstant = configuration.get("rain", "rainDurationConstant", 12000).getInt();
            this.rainDurationModulator = configuration.get("rain", "rainDurationModulator", 12000).getInt();
            this.rainBreakConstant = configuration.get("rain", "rainBreakConstant", 12000).getInt();
            this.rainBreakModulator = configuration.get("rain", "rainBreakModulator", 168000).getInt();
            this.thunderDurationConstant = configuration.get("thunder", "thunderDurationConstant", 3600).getInt();
            this.thunderDurationModulator = configuration.get("thunder", "thunderDurationModulator", 12000).getInt();
            this.thunderBreakConstant = configuration.get("thunder", "thunderBreakConstant", 12000).getInt();
            this.thunderBreakModulator = configuration.get("thunder", "thunderBreakModulator", 168000).getInt();
            return this;
        }
    }
}

