/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.grid.block;

import CoroUtil.util.CoroUtilBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlockStaticDataMap {
    public static HashMap<String, Float> mapBlockWeight;
    public static HashMap<String, Integer> mapBlockHashNameToID;
    public static HashMap<Integer, String> mapBlockHashIDToName;

    public static void initWeightMap() {
        mapBlockWeight = new HashMap();
        mapBlockHashNameToID = new HashMap();
        mapBlockHashIDToName = new HashMap();
        ArrayList<String> fails = new ArrayList<String>();
        Iterator it = Block.field_149771_c.func_148742_b().iterator();
        int i = 0;
        while (it.hasNext()) {
            String tagName = (String)it.next();
            Block block = (Block)Block.field_149771_c.func_82594_a(tagName);
            if (block == null) continue;
            String hash = CoroUtilBlock.getNameByBlock(block);
            if (mapBlockHashNameToID.containsKey(hash)) {
                fails.add("ID: " + i + " vs " + mapBlockHashNameToID.get(hash) + " - " + hash);
            }
            mapBlockHashNameToID.put(hash, i);
            mapBlockHashIDToName.put(i, hash);
        }
        float m = 5.0f;
        float lightlyPacked = 1.0f;
        float plant = m * 0.5f;
        float glass = m;
        float crystal = m;
        float plank = m * 2.0f;
        float mixedManufactured = m * 2.0f;
        float treeWood = m * 3.0f;
        float stoneWeak = m * 3.0f;
        float woodMachines = m * 3.0f;
        float stoneMachine = m * 4.0f;
        float stoneReinforced = m * 5.0f;
        float gold = m * 6.0f;
        float stoneNatural = m * 7.0f;
        float iron = m * 8.0f;
        float steel = m * 10.0f;
        float obsidian = m * 15.0f;
        float diamond = m * 30.0f;
        float unbreakable = -1.0f;
        BlockStaticDataMap.addToMap((Block)Blocks.field_150349_c, lightlyPacked);
        BlockStaticDataMap.addToMap(Blocks.field_150346_d, lightlyPacked);
        BlockStaticDataMap.addToMap((Block)Blocks.field_150354_m, lightlyPacked);
        BlockStaticDataMap.addToMap(Blocks.field_150351_n, lightlyPacked);
        BlockStaticDataMap.addToMap((Block)Blocks.field_150362_t, plant);
        BlockStaticDataMap.addToMap(Blocks.field_150396_be, plank);
        BlockStaticDataMap.addToMap(Blocks.field_150344_f, plank);
        BlockStaticDataMap.addToMap(Blocks.field_150485_bF, plank);
        BlockStaticDataMap.addToMap(Blocks.field_150487_bG, plank);
        BlockStaticDataMap.addToMap(Blocks.field_150481_bH, plank);
        BlockStaticDataMap.addToMap(Blocks.field_150372_bz, plank);
        BlockStaticDataMap.addToMap(Blocks.field_150359_w, glass);
        BlockStaticDataMap.addToMap(Blocks.field_150432_aD, glass);
        BlockStaticDataMap.addToMap(Blocks.field_150410_aZ, glass);
        BlockStaticDataMap.addToMap(Blocks.field_150322_A, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150347_e, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150341_Y, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150463_bK, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150365_q, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150482_ag, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150412_bA, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150352_o, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150366_p, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150369_x, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150449_bY, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150450_ax, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150435_aG, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150424_aL, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150386_bk, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150405_ch, stoneWeak);
        BlockStaticDataMap.addToMap(Blocks.field_150364_r, treeWood);
        BlockStaticDataMap.addToMap(Blocks.field_150363_s, treeWood);
        BlockStaticDataMap.addToMap(Blocks.field_150367_z, stoneMachine);
        BlockStaticDataMap.addToMap((Block)Blocks.field_150320_F, stoneMachine);
        BlockStaticDataMap.addToMap((Block)Blocks.field_150331_J, stoneMachine);
        BlockStaticDataMap.addToMap((Block)Blocks.field_150326_M, stoneMachine);
        BlockStaticDataMap.addToMap((Block)Blocks.field_150332_K, stoneMachine);
        BlockStaticDataMap.addToMap(Blocks.field_150367_z, stoneMachine);
        BlockStaticDataMap.addToMap(Blocks.field_150336_V, stoneReinforced);
        BlockStaticDataMap.addToMap(Blocks.field_150417_aV, stoneReinforced);
        BlockStaticDataMap.addToMap(Blocks.field_150411_aY, stoneReinforced);
        BlockStaticDataMap.addToMap(Blocks.field_150385_bj, stoneReinforced);
        BlockStaticDataMap.addToMap(Blocks.field_150387_bl, stoneReinforced);
        BlockStaticDataMap.addToMap(Blocks.field_150389_bf, stoneReinforced);
        BlockStaticDataMap.addToMap(Blocks.field_150390_bg, stoneReinforced);
        BlockStaticDataMap.addToMap(Blocks.field_150348_b, stoneNatural);
        BlockStaticDataMap.addToMap(Blocks.field_150343_Z, obsidian);
        BlockStaticDataMap.addToMap(Blocks.field_150484_ah, diamond);
        BlockStaticDataMap.addToMap((Block)Blocks.field_150480_ab, iron);
        BlockStaticDataMap.addToMap(Blocks.field_150357_h, unbreakable);
    }

    public static void addToMap(Block block, float strength) {
        if (mapBlockWeight.containsKey(CoroUtilBlock.getNameByBlock(block))) {
            System.out.println("EPOCH DATA MAP WARNING, adding existing unlocalizedname to map: " + block.func_149739_a());
        }
        mapBlockWeight.put(CoroUtilBlock.getNameByBlock(block), Float.valueOf(strength));
    }

    public static float getBlockStength(String name) {
        float str = 1.0f;
        if (mapBlockWeight.containsKey(name)) {
            return mapBlockWeight.get(name).floatValue();
        }
        return str;
    }

    public static float getBlockStength(Block id) {
        float str = 1.0f;
        if (mapBlockHashIDToName.containsKey(id)) {
            return BlockStaticDataMap.getBlockStength(mapBlockHashIDToName.get(id));
        }
        System.out.println("epoch block id to name lookup fail for: " + id);
        return str;
    }

    public static float getBlockMaxHealth(Block id) {
        return 10.0f * BlockStaticDataMap.getBlockStength(id);
    }
}

