/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import ivorius.ivtoolkit.IvToolkitCoreContainer;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponentPlacementStrategies;
import ivorius.ivtoolkit.maze.components.MazeComponentPlacementStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponents;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MazeRoomConnection;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import ivorius.ivtoolkit.maze.components.WeightedMazeComponent;
import ivorius.ivtoolkit.random.WeightedSelector;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Triple;

public class MazeComponentConnector {
    public static <M extends WeightedMazeComponent<C>, C> List<ShiftedMazeComponent<M, C>> randomlyConnect(MorphingMazeComponent<C> morphingComponent, List<M> components, ConnectionStrategy<C> connectionStrategy, MazeComponentPlacementStrategy<M, C> placementStrategy, Random random) {
        ImmutableList.Builder result = new ImmutableList.Builder();
        ArrayDeque<Triple<MazeRoom, MazeRoomConnection, C>> exitStack = new ArrayDeque<Triple<MazeRoom, MazeRoomConnection, C>>();
        Predicate componentPredicate = Predicates.and(MazeComponents.compatibilityPredicate(morphingComponent, connectionStrategy), MazeComponentPlacementStrategies.placeable(placementStrategy));
        WeightedSelector.WeightFunction<ShiftedMazeComponent<M, C>> weightFunction = MazeComponentConnector.getWeightFunction();
        MazeComponentConnector.addAllExits(placementStrategy, exitStack, morphingComponent.exits().entrySet());
        while (exitStack.size() > 0) {
            Triple triple = (Triple)exitStack.removeLast();
            MazeRoom room = (MazeRoom)triple.getLeft();
            if (morphingComponent.rooms().contains(room)) continue;
            MazeRoomConnection exit = (MazeRoomConnection)((Object)triple.getMiddle());
            Object connection = triple.getRight();
            ImmutableList placeable = FluentIterable.from(components).transformAndConcat(MazeComponents.shiftAllFunction(exit, connection, connectionStrategy)).filter(componentPredicate).toList();
            if (placeable.size() == 0) {
                IvToolkitCoreContainer.logger.warn("Did not find fitting component for maze!");
                IvToolkitCoreContainer.logger.warn("Suggested: X with exits " + FluentIterable.from(morphingComponent.exits().entrySet()).filter(MazeComponentConnector.entryConnectsTo(room)));
                continue;
            }
            ShiftedMazeComponent selected = WeightedSelector.canSelect(placeable, weightFunction) ? WeightedSelector.select(random, placeable, weightFunction) : (ShiftedMazeComponent)placeable.get(random.nextInt(placeable.size()));
            MazeComponentConnector.addAllExits(placementStrategy, exitStack, selected.exits().entrySet());
            morphingComponent.add(selected);
            result.add((Object)selected);
        }
        return result.build();
    }

    private static Predicate<Map.Entry<MazeRoomConnection, ?>> entryConnectsTo(final MazeRoom finalRoom) {
        return new Predicate<Map.Entry<MazeRoomConnection, ?>>(){

            public boolean apply(@Nullable Map.Entry<MazeRoomConnection, ?> input) {
                return input != null && input.getKey().has(finalRoom);
            }
        };
    }

    private static <M extends WeightedMazeComponent<C>, C> void addAllExits(MazeComponentPlacementStrategy<M, C> placementStrategy, Deque<Triple<MazeRoom, MazeRoomConnection, C>> exitStack, Set<Map.Entry<MazeRoomConnection, C>> entries) {
        for (Map.Entry<MazeRoomConnection, C> exit : entries) {
            MazeRoomConnection connection = exit.getKey();
            C c = exit.getValue();
            if (placementStrategy.shouldContinue(connection.getLeft(), connection.getRight(), c)) {
                exitStack.add(Triple.of((Object)connection.getLeft(), (Object)((Object)connection), c));
            }
            if (!placementStrategy.shouldContinue(connection.getRight(), connection.getLeft(), c)) continue;
            exitStack.add(Triple.of((Object)connection.getRight(), (Object)((Object)connection), c));
        }
    }

    private static <M extends WeightedMazeComponent<C>, C> WeightedSelector.WeightFunction<ShiftedMazeComponent<M, C>> getWeightFunction() {
        return new WeightedSelector.WeightFunction<ShiftedMazeComponent<M, C>>(){

            @Override
            public double apply(ShiftedMazeComponent<M, C> item) {
                return ((WeightedMazeComponent)item.getComponent()).getWeight();
            }
        };
    }
}

