/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.core.genetics.alleles.Allele;
import net.minecraft.item.ItemStack;

public abstract class BeeVariation
implements IBeeDefinition {
    private final IAllele[] template;
    private final IBeeGenome genome;

    public BeeVariation(IBeeDefinition bee) {
        this.template = bee.getTemplate();
        this.initializeTemplate(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
    }

    protected abstract void initializeTemplate(IAllele[] var1);

    @Override
    public IAllele[] getTemplate() {
        return this.template;
    }

    @Override
    public IBeeGenome getGenome() {
        return this.genome;
    }

    @Override
    public IBee getIndividual() {
        return new Bee(this.genome);
    }

    @Override
    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack(bee, beeType.ordinal());
    }

    public static class RainResist
    extends BeeVariation {
        public RainResist(IBeeDefinition bee) {
            super(bee);
        }

        @Override
        protected void initializeTemplate(IAllele[] template) {
            Allele.helper.set(template, EnumBeeChromosome.TOLERANT_FLYER, true);
        }
    }
}

