/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network;

import forestry.apiculture.gadgets.TileCandle;
import forestry.apiculture.gui.ContainerImprinter;
import forestry.apiculture.network.PacketUpdateCandle;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.IPacketHandler;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketId;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketHandlerApiculture
implements IPacketHandler {
    @Override
    public boolean onPacketData(PacketId packetID, DataInputStreamForestry data, EntityPlayer player) throws IOException {
        switch (packetID) {
            case HABITAT_BIOME_POINTER: {
                PacketCoordinates packet = new PacketCoordinates(data);
                Proxies.common.setHabitatLocatorCoordinates((Entity)player, packet.getCoordinates());
                return true;
            }
            case IMPRINT_SELECTION_GET: {
                PacketHandlerApiculture.onImprintSelectionGet(player);
                return true;
            }
            case CANDLE: {
                PacketUpdateCandle updateCandle = new PacketUpdateCandle(data);
                PacketHandlerApiculture.onCandleUpdate(updateCandle);
                return true;
            }
        }
        return false;
    }

    private static void onImprintSelectionGet(EntityPlayer playerEntity) {
        if (!(playerEntity.field_71070_bA instanceof ContainerImprinter)) {
            return;
        }
        ((ContainerImprinter)playerEntity.field_71070_bA).sendSelection(playerEntity);
    }

    private static void onCandleUpdate(PacketUpdateCandle updateCandle) {
        TileEntity tileEntity = updateCandle.getTarget(Proxies.common.getRenderWorld());
        if (tileEntity instanceof TileCandle) {
            ((TileCandle)tileEntity).onPacketUpdate(updateCandle);
        }
    }
}

