/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.arboriculture.gadgets.TileTreeContainer;
import forestry.arboriculture.network.PacketRipeningUpdate;
import forestry.core.EnumErrorCode;
import forestry.core.genetics.alleles.Allele;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.PacketTileStream;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Utils;
import forestry.plugins.PluginArboriculture;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.EnumPlantType;

public class TileLeaves
extends TileTreeContainer
implements IPollinatable,
IFruitBearer,
IButterflyNursery {
    private int colourLeaves;
    private int colourFruits;
    private short textureIndexFancy = (short)48;
    private short textureIndexPlain = (short)64;
    private short textureIndexFruits = (short)-1;
    private boolean isFruitLeaf;
    private boolean isPollinatedState;
    private int ripeningTime;
    private short ripeningPeriod = (short)32766;
    private boolean isDecorative = false;
    private int maturationTime;
    private int damage;
    private BiomeGenBase biome;
    private IEffectData[] effectData = new IEffectData[2];
    private static final short hasFruitFlag = 1;
    private static final short isPollinatedFlag = 2;
    private IButterfly caterpillar;

    private void updateBiome() {
        if (this.field_145850_b == null) {
            return;
        }
        this.biome = this.field_145850_b.getBiomeGenForCoordsBody(this.field_145851_c, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.ripeningTime = nbttagcompound.func_74765_d("RT");
        this.damage = nbttagcompound.func_74762_e("ENC");
        if (nbttagcompound.func_74764_b("CATER")) {
            this.maturationTime = nbttagcompound.func_74762_e("CATMAT");
            this.caterpillar = (IButterfly)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies").getMember(nbttagcompound.func_74775_l("CATER"));
        }
        this.isDecorative = nbttagcompound.func_74764_b("Decorative") ? nbttagcompound.func_74767_n("Decorative") : nbttagcompound.func_74767_n("DEC");
        ITree tree = this.getTree();
        if (tree != null) {
            this.setTree(tree);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("RT", this.getRipeningTime());
        nbttagcompound.func_74768_a("ENC", this.damage);
        if (this.caterpillar != null) {
            nbttagcompound.func_74768_a("CATMAT", this.maturationTime);
            NBTTagCompound subcompound = new NBTTagCompound();
            this.caterpillar.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("CATER", (NBTBase)subcompound);
        }
        nbttagcompound.func_74757_a("DEC", this.isDecorative);
    }

    @Override
    public void onBlockTick() {
        if (this.biome == null) {
            this.updateBiome();
        }
        ITree tree = this.getTree();
        if (this.isDecorative || tree == null) {
            return;
        }
        ITreeGenome genome = tree.getGenome();
        boolean isDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        for (ILeafTickHandler tickHandler : genome.getPrimary().getRoot().getLeafTickHandlers()) {
            if (!tickHandler.onRandomLeafTick(tree, this.field_145850_b, this.biome.field_76756_M, this.field_145851_c, this.field_145848_d, this.field_145849_e, isDestroyed)) continue;
            return;
        }
        if (isDestroyed) {
            return;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        if (this.hasFruit() && this.getRipeningTime() < this.ripeningPeriod) {
            ITreekeepingMode treekeepingMode = PluginArboriculture.treeInterface.getTreekeepingMode(this.field_145850_b);
            float sappinessModifier = treekeepingMode.getSappinessModifier(genome, 1.0f);
            float sappiness = genome.getSappiness() * sappinessModifier;
            if (this.field_145850_b.field_73012_v.nextFloat() < sappiness) {
                ++this.ripeningTime;
                this.sendNetworkUpdateRipening();
            }
        }
        if (this.caterpillar != null) {
            this.matureCaterpillar();
        }
        this.effectData = tree.doEffect(this.effectData, this.field_145850_b, this.biome.field_76756_M, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void setTree(ITree tree) {
        super.setTree(tree);
        ITreeGenome genome = tree.getGenome();
        IAlleleTreeSpecies species = genome.getPrimary();
        if (tree.canBearFruit()) {
            IFruitProvider fruitProvider = genome.getFruitProvider();
            this.isFruitLeaf = fruitProvider.markAsFruitLeaf(genome, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.isFruitLeaf) {
                this.textureIndexFruits = species == Allele.treeOak && fruitProvider == Allele.fruitApple.getProvider() ? (short)-1 : fruitProvider.getIconIndex(genome, (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getRipeningTime(), true);
                this.ripeningPeriod = (short)tree.getGenome().getFruitProvider().getRipeningPeriod();
            }
        } else {
            this.isFruitLeaf = false;
            this.textureIndexFruits = (short)-1;
        }
        this.textureIndexFancy = species.getLeafIconIndex(tree, true);
        this.textureIndexPlain = species.getLeafIconIndex(tree, false);
        this.colourLeaves = species.getLeafColour(tree);
        if (TileLeaves.isDestroyed(tree, this.damage)) {
            this.colourLeaves = Utils.addRGBComponents(this.colourLeaves, 92, 61, 0);
        } else if (this.caterpillar != null) {
            this.colourLeaves = Utils.multiplyRGBComponents(this.colourLeaves, 1.5f);
        }
    }

    private static boolean isDestroyed(ITree tree, int damage) {
        if (tree == null) {
            return false;
        }
        return damage > tree.getResilience();
    }

    public boolean isPollinated() {
        ITree tree = this.getTree();
        return tree != null && !TileLeaves.isDestroyed(tree, this.damage) && tree.getMate() != null;
    }

    public int getFoliageColour(EntityPlayer player) {
        return this.isPollinatedState && GeneticsUtil.hasNaturalistEye(player) ? 0xFFFFFF : this.colourLeaves;
    }

    public int getFruitColour() {
        if (this.colourFruits == 0 && this.hasFruit()) {
            this.colourFruits = this.determineFruitColour();
        }
        return this.colourFruits;
    }

    private int determineFruitColour() {
        ITree tree = this.getTree();
        ITreeGenome genome = tree.getGenome();
        IFruitProvider fruit = genome.getFruitProvider();
        return fruit.getColour(genome, (IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getRipeningTime());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(boolean fancy) {
        if (fancy) {
            return TextureManager.getInstance().getIcon(this.textureIndexFancy);
        }
        return TextureManager.getInstance().getIcon(this.textureIndexPlain);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFruitTexture() {
        if (this.textureIndexFruits >= 0) {
            return TextureManager.getInstance().getIcon(this.textureIndexFruits);
        }
        return null;
    }

    public int getRipeningTime() {
        return this.isDecorative ? this.ripeningPeriod : this.ripeningTime;
    }

    public void setDecorative() {
        this.isDecorative = true;
    }

    public boolean isDecorative() {
        return this.isDecorative;
    }

    @Override
    public EnumSet<EnumPlantType> getPlantType() {
        if (this.getTree() == null) {
            return EnumSet.noneOf(EnumPlantType.class);
        }
        return this.getTree().getPlantTypes();
    }

    @Override
    public boolean canMateWith(IIndividual individual) {
        if (this.getTree() == null || this.isDecorative) {
            return false;
        }
        if (this.getTree().getMate() != null) {
            return false;
        }
        if (!(individual instanceof ITree)) {
            return false;
        }
        return !this.getTree().isGeneticEqual(individual);
    }

    @Override
    public void mateWith(IIndividual individual) {
        if (this.getTree() == null || this.isDecorative) {
            return;
        }
        this.getTree().mate((ITree)individual);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public IIndividual getPollen() {
        if (this.isDecorative) {
            return null;
        }
        return this.getTree();
    }

    public String getUnlocalizedName() {
        ITree tree = this.getTree();
        if (tree == null) {
            return "for.leaves.corrupted";
        }
        return tree.getGenome().getPrimary().getUnlocalizedName();
    }

    @Override
    public Packet func_145844_m() {
        return new PacketTileStream(this).getPacket();
    }

    public void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(new PacketTileStream(this));
    }

    private void sendNetworkUpdateRipening() {
        int newColourFruits = this.determineFruitColour();
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        PacketRipeningUpdate ripeningUpdate = new PacketRipeningUpdate(this);
        Proxies.net.sendNetworkPacket(ripeningUpdate);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        int leafState = 0;
        boolean hasFruit = this.hasFruit();
        if (this.isPollinated()) {
            leafState = (byte)(leafState | 2);
        }
        if (hasFruit) {
            leafState = (byte)(leafState | 1);
        }
        data.writeByte(leafState);
        if (hasFruit) {
            String fruitAlleleUID = this.getTree().getGenome().getActiveAllele(EnumTreeChromosome.FRUITS).getUID();
            int colourFruits = this.getFruitColour();
            data.writeUTF(fruitAlleleUID);
            data.writeInt(colourFruits);
        }
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        IAllele fruitAllele;
        String speciesUID = data.readUTF();
        byte leafState = data.readByte();
        this.isFruitLeaf = (leafState & 1) > 0;
        this.isPollinatedState = (leafState & 2) > 0;
        String fruitAlleleUID = null;
        if (this.isFruitLeaf) {
            fruitAlleleUID = data.readUTF();
            this.colourFruits = data.readInt();
        }
        IAllele[] treeTemplate = PluginArboriculture.treeInterface.getTemplate(speciesUID);
        if (fruitAlleleUID != null && (fruitAllele = AlleleManager.alleleRegistry.getAllele(fruitAlleleUID)) != null) {
            treeTemplate[EnumTreeChromosome.FRUITS.ordinal()] = fruitAllele;
        }
        if (treeTemplate != null) {
            ITree tree = PluginArboriculture.treeInterface.templateAsIndividual(treeTemplate);
            if (this.isPollinatedState) {
                tree.mate(tree);
            }
            this.setTree(tree);
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void fromRipeningPacket(int newColourFruits) {
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return !Block.func_149680_a((Block)oldBlock, (Block)newBlock);
    }

    @Override
    public Collection<ItemStack> pickFruit(ItemStack tool) {
        ITree tree = this.getTree();
        if (tree == null || !this.hasFruit() || this.isDecorative) {
            return Collections.emptyList();
        }
        ItemStack[] produceStacks = tree.produceStacks(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getRipeningTime());
        this.ripeningTime = 0;
        this.sendNetworkUpdateRipening();
        return Arrays.asList(produceStacks);
    }

    @Override
    public IFruitFamily getFruitFamily() {
        ITree tree = this.getTree();
        if (tree == null) {
            return null;
        }
        return tree.getGenome().getFruitProvider().getFamily();
    }

    @Override
    public float getRipeness() {
        if (this.ripeningPeriod == 0) {
            return 1.0f;
        }
        if (this.getTree() == null) {
            return 0.0f;
        }
        return (float)this.getRipeningTime() / (float)this.ripeningPeriod;
    }

    @Override
    public boolean hasFruit() {
        return this.isFruitLeaf && !TileLeaves.isDestroyed(this.getTree(), this.damage);
    }

    @Override
    public void addRipeness(float add) {
        if (this.getTree() == null || !this.isFruitLeaf || this.getRipeningTime() >= this.ripeningPeriod || this.isDecorative) {
            return;
        }
        this.ripeningTime = (int)((float)this.ripeningTime + (float)this.ripeningPeriod * add);
        this.sendNetworkUpdateRipening();
    }

    private void matureCaterpillar() {
        ++this.maturationTime;
        ITree tree = this.getTree();
        boolean wasDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        this.damage += this.caterpillar.getGenome().getMetabolism();
        IButterflyGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getLifespan() / (float)(caterpillarGenome.getFertility() * 2));
        if (this.maturationTime >= caterpillarMatureTime && this.caterpillar.canTakeFlight(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
                TileLeaves.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
                TileLeaves.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
                TileLeaves.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
                TileLeaves.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            }
            this.setCaterpillar(null);
        } else if (!wasDestroyed && TileLeaves.isDestroyed(tree, this.damage)) {
            this.sendNetworkUpdate();
        }
    }

    private static void attemptButterflySpawn(World world, IButterfly butterfly, double x, double y, double z) {
        IButterflyRoot butterflyRoot = (IButterflyRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
        if (butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), x, y + (double)0.1f, z) != null) {
            Proxies.log.finest("A caterpillar '%s' hatched at %s/%s/%s.", butterfly.getDisplayName(), x, y, z);
        }
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public int getYCoord() {
        return this.field_145848_d;
    }

    @Override
    public int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.biome;
    }

    @Override
    public EnumTemperature getTemperature() {
        return null;
    }

    @Override
    public EnumHumidity getHumidity() {
        return null;
    }

    @Override
    public boolean setErrorCondition(boolean condition, IErrorState errorState) {
        return condition;
    }

    public ImmutableSet<IErrorState> getErrorStates() {
        return ImmutableSet.of();
    }

    @Override
    public void setErrorState(IErrorState state) {
    }

    @Override
    public EnumErrorCode getErrorState() {
        return null;
    }

    @Override
    public boolean addProduct(ItemStack product, boolean all) {
        return false;
    }

    @Override
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public IIndividual getNanny() {
        return this.getTree();
    }

    @Override
    public void setCaterpillar(IButterfly butterfly) {
        if (this.isDecorative) {
            return;
        }
        this.maturationTime = 0;
        this.caterpillar = butterfly;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean canNurse(IButterfly butterfly) {
        ITree tree = this.getTree();
        return !this.isDecorative && !TileLeaves.isDestroyed(tree, this.damage) && this.caterpillar == null;
    }

    @Override
    public GameProfile getOwnerName() {
        return this.getOwner();
    }
}

