/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.base.Objects;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.core.proxy.Proxies;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class Chromosome
implements IChromosome {
    private static final String UID0_TAG = "UID0";
    private static final String UID1_TAG = "UID1";
    private IAllele primary;
    private IAllele secondary;

    private Chromosome() {
    }

    public Chromosome(IAllele allele) {
        this.primary = this.secondary = allele;
    }

    public Chromosome(IAllele primary, IAllele secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.primary = AlleleManager.alleleRegistry.getAllele(nbttagcompound.func_74779_i(UID0_TAG));
        this.secondary = AlleleManager.alleleRegistry.getAllele(nbttagcompound.func_74779_i(UID1_TAG));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a(UID0_TAG, this.primary.getUID());
        nbttagcompound.func_74778_a(UID1_TAG, this.secondary.getUID());
    }

    @Override
    public IAllele getPrimaryAllele() {
        return this.primary;
    }

    @Override
    public IAllele getSecondaryAllele() {
        return this.secondary;
    }

    @Override
    public IAllele getActiveAllele() {
        if (this.primary == null || this.secondary == null) {
            return null;
        }
        if (this.primary.isDominant()) {
            return this.primary;
        }
        if (this.secondary.isDominant()) {
            return this.secondary;
        }
        return this.primary;
    }

    @Override
    public IAllele getInactiveAllele() {
        if (!this.secondary.isDominant()) {
            return this.secondary;
        }
        if (!this.primary.isDominant()) {
            return this.primary;
        }
        return this.secondary;
    }

    public IAllele getRandomAllele(Random rand) {
        if (rand.nextBoolean()) {
            return this.primary;
        }
        return this.secondary;
    }

    public boolean overrideInvalidAlleles(IAllele template, Class<? extends IAllele> chromosomeClass) {
        boolean foundInvalidAlleles = false;
        if (this.primary != null && chromosomeClass.isInstance(this.primary)) {
            template = this.primary;
        } else if (this.secondary != null && chromosomeClass.isInstance(this.secondary)) {
            template = this.secondary;
        }
        if (this.primary == null) {
            Proxies.log.warning("Missing primary allele: {0}. Setting to: {1}", this, template);
            this.primary = template;
            foundInvalidAlleles = true;
        } else if (!chromosomeClass.isInstance(this.primary)) {
            Proxies.log.warning("Wrong primary allele: {0}. Setting to: {1}", this, template);
            this.primary = template;
            foundInvalidAlleles = true;
        }
        if (this.secondary == null) {
            Proxies.log.warning("Missing secondary allele: {0}. Setting to: {1}", this, template);
            this.secondary = template;
            foundInvalidAlleles = true;
        } else if (!chromosomeClass.isInstance(this.secondary)) {
            Proxies.log.warning("Wrong secondary allele: {0}. Setting to: {1}", this, template);
            this.secondary = template;
            foundInvalidAlleles = true;
        }
        return foundInvalidAlleles;
    }

    public boolean hasInvalidAlleles(Class<? extends IAllele> chromosomeClass) {
        if (this.primary == null) {
            Proxies.log.severe("Missing primary allele: {0}", (Object)this);
            return true;
        }
        if (!chromosomeClass.isInstance(this.primary)) {
            Proxies.log.severe("Wrong primary allele for: {0}. Should be: {1}", this, chromosomeClass.getSimpleName());
            return true;
        }
        if (this.secondary == null) {
            Proxies.log.severe("Missing secondary allele: {0}", (Object)this);
            return true;
        }
        if (!chromosomeClass.isInstance(this.secondary)) {
            Proxies.log.severe("Wrong secondary allele for: {0}. Should be: {1}", this, chromosomeClass.getSimpleName());
            return true;
        }
        return false;
    }

    public static Chromosome loadChromosomeFromNBT(NBTTagCompound compound) {
        Chromosome chromosome = new Chromosome();
        chromosome.readFromNBT(compound);
        return chromosome;
    }

    public static IChromosome inheritChromosome(Random rand, IChromosome parent1, IChromosome parent2) {
        IAllele choice1 = rand.nextBoolean() ? parent1.getPrimaryAllele() : parent1.getSecondaryAllele();
        IAllele choice2 = rand.nextBoolean() ? parent2.getPrimaryAllele() : parent2.getSecondaryAllele();
        if (rand.nextBoolean()) {
            return new Chromosome(choice1, choice2);
        }
        return new Chromosome(choice2, choice1);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Primary", (Object)this.primary).add("Secondary", (Object)this.secondary).toString();
    }
}

