/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.inventory.ITileFilter;
import forestry.core.inventory.InvTools;
import forestry.core.utils.AdjacentTileCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class AdjacentInventoryCache
implements AdjacentTileCache.ICacheListener {
    private final AdjacentTileCache cache;
    private boolean changed = true;
    private final List<IInventory> invs = new LinkedList<IInventory>();
    private final IInventory[] sides = new IInventory[6];
    private final Comparator<IInventory> sorter;
    private final ITileFilter filter;

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache) {
        this(tile, cache, null, null);
    }

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache, ITileFilter filter, Comparator<IInventory> sorter) {
        this.cache = cache;
        this.filter = filter;
        this.sorter = sorter;
        cache.addListener(this);
    }

    public IInventory getAdjacentInventory(ForgeDirection side) {
        this.checkChanged();
        return this.sides[side.ordinal()];
    }

    public Collection<IInventory> getAdjacentInventories() {
        this.checkChanged();
        return this.invs;
    }

    @Override
    public void changed() {
        this.changed = true;
    }

    @Override
    public void purge() {
        this.invs.clear();
        Arrays.fill(this.sides, null);
    }

    private void checkChanged() {
        this.cache.refresh();
        if (this.changed) {
            this.changed = false;
            this.purge();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IInventory inv;
                TileEntity tile = this.cache.getTileOnSide(side);
                if (tile == null || this.filter != null && !this.filter.matches(tile) || (inv = InvTools.getInventoryFromTile(tile, side.getOpposite())) == null) continue;
                this.sides[side.ordinal()] = inv;
                this.invs.add(inv);
            }
            if (this.sorter != null) {
                Collections.sort(this.invs, this.sorter);
            }
        }
    }
}

