/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.config.Config;
import forestry.core.items.ItemForestry;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemOverlay
extends ItemForestry {
    private final OverlayInfo[] overlays;
    @SideOnly(value=Side.CLIENT)
    private IIcon primaryIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon secondaryIcon;

    public ItemOverlay(CreativeTabs tab, OverlayInfo ... overlays) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(tab);
        this.overlays = overlays;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.overlays.length; ++i) {
            if (!Config.isDebug && this.overlays[i].isSecret) continue;
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.primaryIcon = TextureManager.getInstance().registerTex(register, StringUtil.cleanItemName(this) + ".0");
        if (this.overlays[0].secondaryColor != 0) {
            this.secondaryIcon = TextureManager.getInstance().registerTex(register, StringUtil.cleanItemName(this) + ".1");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int i, int j) {
        if (j > 0 && this.overlays[i].secondaryColor != 0) {
            return this.secondaryIcon;
        }
        return this.primaryIcon;
    }

    public int getRenderPasses(int metadata) {
        return this.overlays[metadata].secondaryColor != 0 ? 2 : 1;
    }

    public boolean func_77623_v() {
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() < 0 || stack.func_77960_j() >= this.overlays.length) {
            return null;
        }
        return super.func_77667_c(stack) + "." + this.overlays[stack.func_77960_j()].name;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        if (j == 0 || this.overlays[itemstack.func_77960_j()].secondaryColor == 0) {
            return this.overlays[itemstack.func_77960_j()].primaryColor;
        }
        return this.overlays[itemstack.func_77960_j()].secondaryColor;
    }

    public static class OverlayInfo {
        public final String name;
        public final int primaryColor;
        public final int secondaryColor;
        public boolean isSecret = false;

        public OverlayInfo(String name, Color primaryColor, Color secondaryColor) {
            this(name, primaryColor.getRGB(), secondaryColor.getRGB());
        }

        public OverlayInfo(String name, int primaryColor, int secondaryColor) {
            this.name = name;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }

        public OverlayInfo(String name, int primaryColor) {
            this(name, primaryColor, 0);
        }

        public OverlayInfo setIsSecret() {
            this.isSecret = true;
            return this;
        }
    }
}

