/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cofh.api.energy.IEnergyReceiver;
import forestry.core.vect.Vect;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockUtil {
    public static ArrayList<ItemStack> getBlockDrops(World world, Vect posBlock) {
        Block block = world.func_147439_a(posBlock.x, posBlock.y, posBlock.z);
        int meta = world.func_72805_g(posBlock.x, posBlock.y, posBlock.z);
        return block.getDrops(world, posBlock.x, posBlock.y, posBlock.z, meta, 0);
    }

    public static boolean isEnergyReceiver(ForgeDirection side, TileEntity tile) {
        if (!(tile instanceof IEnergyReceiver)) {
            return false;
        }
        IEnergyReceiver receptor = (IEnergyReceiver)tile;
        return receptor.canConnectEnergy(side);
    }

    public static boolean tryPlantPot(World world, int x, int y, int z, Block block) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        world.func_147465_d(x, y, z, block, direction, 2);
        return true;
    }

    public static int getDirectionalMetadata(World world, int x, int y, int z) {
        for (int i = 0; i < 4; ++i) {
            if (!BlockUtil.isValidPot(world, x, y, z, i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidPot(World world, int x, int y, int z, int notchDirection) {
        Block block = world.func_147439_a(x += Direction.field_71583_a[notchDirection], y, z += Direction.field_71581_b[notchDirection]);
        if (block == Blocks.field_150364_r) {
            return BlockLog.func_150165_c((int)world.func_72805_g(x, y, z)) == 3;
        }
        return block.isWood((IBlockAccess)world, x, y, z);
    }

    public static int getMaturityPod(int metadata) {
        return BlockCocoa.func_149987_c((int)metadata);
    }
}

