/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.core.config.ForestryBlock;
import forestry.core.utils.RecipeUtil;
import forestry.factory.gadgets.MachineCarpenter;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.LiquidSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;

public class CraftGuideCarpenter
implements RecipeProvider {
    private final Slot[] slots = new Slot[12];

    public CraftGuideCarpenter() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.slots[i + j * 3] = new ItemSlot(i * 18 + 3, j * 18 + 3, 16, 16).drawOwnBackground();
            }
        }
        this.slots[9] = new ItemSlot(59, 21, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground();
        this.slots[10] = new LiquidSlot(59, 39);
        this.slots[11] = new ItemSlot(59, 3, 16, 16).setSlotType(SlotType.MACHINE_SLOT);
    }

    public void generateRecipes(RecipeGenerator generator) {
        if (ForestryBlock.factoryTESR.block() == null) {
            return;
        }
        ItemStack machine = ForestryBlock.factoryTESR.getItemStack(1, 1);
        RecipeTemplate template = generator.createRecipeTemplate(this.slots, machine);
        for (MachineCarpenter.Recipe recipe : MachineCarpenter.RecipeManager.recipes) {
            Object[] array = new Object[12];
            Object[] flattened = RecipeUtil.getCraftingRecipeAsArray(recipe.asIRecipe());
            if (flattened == null) {
                flattened = generator.getCraftingRecipe(recipe.asIRecipe());
            }
            if (flattened == null) continue;
            System.arraycopy(flattened, 0, array, 0, flattened.length);
            if (recipe.getLiquid() != null) {
                array[10] = recipe.getLiquid();
            }
            array[11] = machine;
            generator.addRecipe(template, array);
        }
    }
}

