/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.core.GameMode;
import forestry.core.fluids.Fluids;
import forestry.core.proxy.Proxies;
import forestry.core.utils.RecipeUtil;
import forestry.farming.logic.FarmableBasicFruit;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="HarvestCraft", name="HarvestCraft", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.harvestcraft.description")
public class PluginHarvestCraft
extends ForestryPlugin {
    private static final String HC = "harvestcraft";

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded(HC);
    }

    @Override
    public String getFailMessage() {
        return "HarvestCraft not found";
    }

    @Override
    protected void registerRecipes() {
        ItemStack hcBeeswaxItem;
        Block fruitBlock;
        ImmutableList berries = ImmutableList.of((Object)"cranberry", (Object)"blackberry", (Object)"blueberry", (Object)"raspberry", (Object)"strawberry");
        ImmutableList fruits = ImmutableList.of((Object)"pineapple", (Object)"cactusfruit", (Object)"cantaloupe", (Object)"grape", (Object)"kiwi", (Object)"chilipepper");
        ImmutableList treeFruits = ImmutableList.of((Object)"banana", (Object)"dragonfruit", (Object)"lemon", (Object)"lime", (Object)"mango", (Object)"orange", (Object)"papaya", (Object)"peach", (Object)"pear", (Object)"plum", (Object)"pomegranate", (Object)"starfruit", (Object[])new String[]{"apricot", "date", "fig", "grapefruit", "persimmon", "avocado", "coconut", "durian"});
        ImmutableList trees = ImmutableList.of((Object)"nutmeg", (Object)"olive", (Object)"peppercorn");
        ImmutableList treesSpecial = ImmutableList.of((Object)"cinnamon", (Object)"maple", (Object)"paperbark", (Object)"vanillabean", (Object)"apple");
        ImmutableList herbs = ImmutableList.of((Object)"garlic");
        ImmutableList spices = ImmutableList.of((Object)"ginger", (Object)"spiceleaf", (Object)"mustardseed");
        ImmutableList vegetables = ImmutableList.of((Object)"asparagus", (Object)"bean", (Object)"beet", (Object)"broccoli", (Object)"cauliflower", (Object)"celery", (Object)"leek", (Object)"lettuce", (Object)"onion", (Object)"parsnip", (Object)"radish", (Object)"rutabaga", (Object[])new String[]{"scallion", "soybean", "sweetpotato", "turnip", "whitemushroom", "artichoke", "bellpepper", "brusselsprout", "cabbage", "corn", "cucumber", "eggplant", "okra", "peas", "rhubarb", "seaweed", "tomato", "wintersquash", "zucchini", "bambooshoot", "spinach"});
        ImmutableList grains = ImmutableList.of((Object)"barley", (Object)"oats", (Object)"rye");
        ImmutableList cropNuts = ImmutableList.of((Object)"peanut");
        ImmutableList nuts = ImmutableList.of((Object)"walnut", (Object)"almond", (Object)"cashew", (Object)"chestnut", (Object)"pecan", (Object)"pistachio", (Object)"cherry");
        ImmutableList.Builder genericCropsBuilder = ImmutableList.builder();
        genericCropsBuilder.add((Object[])new String[]{"cotton", "rice", "tea", "coffee", "candleberry"});
        genericCropsBuilder.addAll((Iterable)herbs);
        genericCropsBuilder.addAll((Iterable)spices);
        ImmutableList genericCrops = genericCropsBuilder.build();
        ImmutableList.Builder plants = ImmutableList.builder();
        int juiceAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") / 25;
        int seedamount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.seed");
        ItemStack wheatamount = GameMode.getGameMode().getStackSetting("recipe.output.compost.wheat");
        juiceAmount = Math.max(juiceAmount, 1);
        for (String berryName : berries) {
            ItemStack berry = GameRegistry.findItemStack((String)HC, (String)(berryName + "Item"), (int)1);
            ItemStack berrySeed = GameRegistry.findItemStack((String)HC, (String)(berryName + "seedItem"), (int)1);
            Block berryBlock = GameRegistry.findBlock((String)HC, (String)("pam" + berryName + "Crop"));
            if (berry != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{berry}, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (berrySeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{berrySeed}, Fluids.SEEDOIL.getFluid(seedamount));
            }
            if (berrySeed != null && berryBlock != null) {
                Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(berrySeed, berryBlock, 7));
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(berryBlock, 7));
            }
            plants.add((Object)berryName);
        }
        juiceAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple");
        for (String fruitName : fruits) {
            ItemStack fruit = GameRegistry.findItemStack((String)HC, (String)(fruitName + "Item"), (int)1);
            ItemStack fruitSeed = GameRegistry.findItemStack((String)HC, (String)(fruitName + "seedItem"), (int)1);
            Block fruitBlock2 = GameRegistry.findBlock((String)HC, (String)("pam" + fruitName + "Crop"));
            if (fruit != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{fruit}, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (fruitSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{fruitSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            }
            if (fruitSeed != null && fruitBlock2 != null) {
                Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(fruitSeed, fruitBlock2, 7));
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(fruitBlock2, 7));
            }
            plants.add((Object)fruitName);
        }
        juiceAmount = GameMode.getGameMode().getIntegerSetting("squeezer.liquid.apple") / 2;
        juiceAmount = Math.max(juiceAmount, 1);
        for (String vegetableName : vegetables) {
            ItemStack vegetable = GameRegistry.findItemStack((String)HC, (String)(vegetableName + "Item"), (int)1);
            ItemStack vegetableSeed = GameRegistry.findItemStack((String)HC, (String)(vegetableName + "seedItem"), (int)1);
            Block vegetableBlock = GameRegistry.findBlock((String)HC, (String)("pam" + vegetableName + "Crop"));
            if (vegetable != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{vegetable}, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (vegetableSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{vegetableSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            }
            if (vegetableSeed != null && vegetableBlock != null) {
                Farmables.farmables.get("farmVegetables").add(new FarmableGenericCrop(vegetableSeed, vegetableBlock, 7));
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(vegetableBlock, 7));
            }
            plants.add((Object)vegetableName);
        }
        for (String grainName : grains) {
            ItemStack grain = GameRegistry.findItemStack((String)HC, (String)(grainName + "Item"), (int)1);
            ItemStack grainSeed = GameRegistry.findItemStack((String)HC, (String)(grainName + "seedItem"), (int)1);
            Block grainBlock = GameRegistry.findBlock((String)HC, (String)("pam" + grainName + "Crop"));
            if (grain != null && wheatamount.field_77994_a > 0) {
                Proxies.common.addRecipe(wheatamount, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), grain);
            }
            if (grainSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{grainSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            }
            if (grainSeed != null && grainBlock != null) {
                Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(grainSeed, grainBlock, 7));
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(grainBlock, 7));
            }
            plants.add((Object)grainName);
        }
        for (String treeFruitName : treeFruits) {
            ItemStack treeFruit = GameRegistry.findItemStack((String)HC, (String)(treeFruitName + "Item"), (int)1);
            Block treeFruitBlock = GameRegistry.findBlock((String)HC, (String)("pam" + Character.toUpperCase(treeFruitName.charAt(0)) + treeFruitName.substring(1)));
            if (treeFruitBlock != null) {
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(treeFruitBlock, 2));
            }
            if (treeFruit != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{treeFruit}, Fluids.JUICE.getFluid(juiceAmount));
            }
            plants.add((Object)treeFruitName);
        }
        for (String treeName : trees) {
            fruitBlock = GameRegistry.findBlock((String)HC, (String)("pam" + Character.toUpperCase(treeName.charAt(0)) + treeName.substring(1)));
            if (fruitBlock != null) {
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(fruitBlock, 2));
            }
            plants.add((Object)treeName);
        }
        for (String treeName : treesSpecial) {
            fruitBlock = GameRegistry.findBlock((String)HC, (String)("pam" + Character.toUpperCase(treeName.charAt(0)) + treeName.substring(1)));
            if (fruitBlock == null) continue;
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(fruitBlock, 2));
        }
        for (String cropName : genericCrops) {
            ItemStack genericCropSeed = GameRegistry.findItemStack((String)HC, (String)(cropName + "seedItem"), (int)1);
            Block genericCropBlock = GameRegistry.findBlock((String)HC, (String)("pam" + cropName + "Crop"));
            if (genericCropSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{genericCropSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            }
            if (genericCropSeed != null && genericCropBlock != null) {
                Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(genericCropSeed, genericCropBlock, 7));
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(genericCropBlock, 7));
            }
            plants.add((Object)cropName);
        }
        for (String plantName : plants.build()) {
            ItemStack plant = GameRegistry.findItemStack((String)HC, (String)(plantName + "Item"), (int)1);
            if (plant == null) continue;
            RecipeUtil.injectLeveledRecipe(plant, GameMode.getGameMode().getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
        for (String cropnutName : cropNuts) {
            ItemStack cropnut = GameRegistry.findItemStack((String)HC, (String)(cropnutName + "Item"), (int)1);
            ItemStack cropnutSeed = GameRegistry.findItemStack((String)HC, (String)(cropnutName + "seedItem"), (int)1);
            Block cropnutBlock = GameRegistry.findBlock((String)HC, (String)("pam" + cropnutName + "Crop"));
            if (cropnutSeed != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{cropnutSeed}, Fluids.SEEDOIL.getFluid(seedamount));
            }
            if (cropnutSeed != null && cropnutBlock != null) {
                Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(cropnutSeed, cropnutBlock, 7));
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(cropnutBlock, 7));
            }
            if (cropnut == null) continue;
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{cropnut}, Fluids.SEEDOIL.getFluid(3 * seedamount));
        }
        for (String nutName : nuts) {
            ItemStack nut = GameRegistry.findItemStack((String)HC, (String)(nutName + "Item"), (int)1);
            Block nutBlock = GameRegistry.findBlock((String)HC, (String)("pam" + Character.toUpperCase(nutName.charAt(0)) + nutName.substring(1)));
            if (nutBlock != null) {
                Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(nutBlock, 2));
            }
            if (nut == null) continue;
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{nut}, Fluids.SEEDOIL.getFluid(3 * seedamount));
        }
        ItemStack hcHoneyItem = GameRegistry.findItemStack((String)HC, (String)"honeyItem", (int)1);
        if (hcHoneyItem != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{hcHoneyItem}, Fluids.HONEY.getFluid(100));
        }
        if ((hcBeeswaxItem = GameRegistry.findItemStack((String)HC, (String)"beeswaxItem", (int)1)) != null) {
            Proxies.common.addRecipe(GameMode.getGameMode().getStackSetting("recipe.output.capsule"), "XXX ", Character.valueOf('X'), hcBeeswaxItem);
        }
    }
}

