/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.mail.EnumAddressee;
import forestry.api.mail.EnumPostage;
import forestry.api.mail.PostManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.fluids.Fluids;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestryBlock;
import forestry.core.network.IPacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.mail.GuiHandlerMail;
import forestry.mail.PacketHandlerMail;
import forestry.mail.PostRegistry;
import forestry.mail.PostalCarrier;
import forestry.mail.SaveEventHandlerMail;
import forestry.mail.TickHandlerMailClient;
import forestry.mail.commands.CommandMail;
import forestry.mail.gadgets.MachineMailbox;
import forestry.mail.gadgets.MachinePhilatelist;
import forestry.mail.gadgets.MachineTrader;
import forestry.mail.items.ItemCatalogue;
import forestry.mail.items.ItemLetter;
import forestry.mail.items.ItemStamps;
import forestry.mail.triggers.MailTriggers;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

@Plugin(pluginID="Mail", name="Mail", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.mail.description")
public class PluginMail
extends ForestryPlugin {
    public static MachineDefinition definitionMailbox;
    public static MachineDefinition definitionTradestation;
    public static MachineDefinition definitionPhilatelist;
    public static ItemStamps.StampInfo[] stampDefinitions;

    @Override
    protected void setupAPI() {
        super.setupAPI();
        PostManager.postRegistry = new PostRegistry();
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.PLAYER));
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.TRADER));
    }

    @Override
    public void preInit() {
        super.preInit();
        PluginCore.rootCommand.addChildCommand(new CommandMail());
        new TickHandlerMailClient();
        ForestryBlock.mail.registerBlock((Block)new BlockBase(Material.field_151573_f), ItemForestryBlock.class, "mail");
        ShapedRecipeCustom recipe = ShapedRecipeCustom.createShapedRecipe(ForestryBlock.mail.getItemStack(1, 0), new Object[]{" # ", "#Y#", "XXX", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), Blocks.field_150486_ae, Character.valueOf('Y'), ForestryItem.sturdyCasing});
        BlockBase mail = (BlockBase)ForestryBlock.mail.block();
        definitionMailbox = mail.addDefinition(new MachineDefinition(0, "forestry.Mailbox", MachineMailbox.class, recipe).setFaces(0, 1, 2, 2, 2, 2, 0, 7));
        recipe = ShapedRecipeCustom.createShapedRecipe(ForestryBlock.mail.getItemStack(1, 1), new Object[]{"Z#Z", "#Y#", "XWX", Character.valueOf('#'), ForestryItem.tubes.getItemStack(1, 2), Character.valueOf('X'), Blocks.field_150486_ae, Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('Z'), ForestryItem.tubes.getItemStack(1, 3), Character.valueOf('W'), ForestryItem.circuitboards.getItemStack(1, 2)});
        definitionTradestation = mail.addDefinition(new MachineDefinition(1, "forestry.Tradestation", MachineTrader.class, recipe).setFaces(0, 1, 2, 3, 4, 4, 0, 7));
        definitionPhilatelist = mail.addDefinition(new MachineDefinition(2, "forestry.Philatelist", MachinePhilatelist.class, new IRecipe[0]).setFaces(0, 1, 2, 3, 2, 2, 0, 7));
    }

    @Override
    protected void registerTriggers() {
        MailTriggers.initialize();
    }

    @Override
    public void doInit() {
        super.doInit();
        definitionMailbox.register();
        definitionTradestation.register();
        definitionPhilatelist.register();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerMail();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerMail();
    }

    @Override
    protected void registerItems() {
        stampDefinitions = new ItemStamps.StampInfo[]{new ItemStamps.StampInfo("1n", EnumPostage.P_1, (Object)ForestryItem.apatite, 4885671, 0xFFFFFF), new ItemStamps.StampInfo("2n", EnumPostage.P_2, "ingotCopper", 15255572, 0xFFFFFF), new ItemStamps.StampInfo("5n", EnumPostage.P_5, "ingotTin", 10225415, 0xFFFFFF), new ItemStamps.StampInfo("10n", EnumPostage.P_10, Items.field_151043_k, 8114616, 0xFFFFFF), new ItemStamps.StampInfo("20n", EnumPostage.P_20, Items.field_151045_i, 16748593, 0xFFF7DD), new ItemStamps.StampInfo("50n", EnumPostage.P_50, Items.field_151166_bC, 6566359, 0xFFF7DD), new ItemStamps.StampInfo("100n", EnumPostage.P_100, Items.field_151156_bN, 14102970, 0xFFF7DD)};
        ForestryItem.stamps.registerItem(new ItemStamps(stampDefinitions), "stamps");
        ForestryItem.letters.registerItem(new ItemLetter(), "letters");
        ForestryItem.catalogue.registerItem(new ItemCatalogue(), "catalogue");
    }

    @Override
    protected void registerRecipes() {
        Item stampGlue;
        if (PluginManager.Module.APICULTURE.isEnabled()) {
            Proxies.common.addShapelessRecipe(ForestryItem.letters.getItemStack(), Items.field_151121_aF, ForestryItem.propolis.getItemStack(1, Short.MAX_VALUE));
            stampGlue = ForestryItem.honeyDrop.item();
        } else {
            Proxies.common.addShapelessRecipe(ForestryItem.letters.getItemStack(), Items.field_151121_aF, Items.field_151123_aH);
            stampGlue = Items.field_151123_aH;
        }
        if (Config.craftingStampsEnabled) {
            for (int i = 0; i < stampDefinitions.length; ++i) {
                if (Config.collectorStamps.contains(PluginMail.stampDefinitions[i].name)) continue;
                Proxies.common.addRecipe(ForestryItem.stamps.getItemStack(9, i), "XXX", "###", "ZZZ", Character.valueOf('X'), stampDefinitions[i].getCraftingIngredient(), Character.valueOf('#'), Items.field_151121_aF, Character.valueOf('Z'), stampGlue);
                RecipeManagers.carpenterManager.addRecipe(10, Fluids.SEEDOIL.getFluid(300), null, ForestryItem.stamps.getItemStack(9, i), "XXX", "###", Character.valueOf('X'), stampDefinitions[i].getCraftingIngredient(), Character.valueOf('#'), Items.field_151121_aF);
            }
        }
        Proxies.common.addRecipe(new ItemStack(Items.field_151121_aF), "###", Character.valueOf('#'), ForestryItem.letters.getItemStack(1, Short.MAX_VALUE));
        RecipeManagers.carpenterManager.addRecipe(10, Fluids.WATER.getFluid(250), null, ForestryItem.letters.getItemStack(), new Object[]{"###", "###", Character.valueOf('#'), ForestryItem.woodPulp});
        Proxies.common.addShapelessRecipe(ForestryItem.catalogue.getItemStack(), ForestryItem.stamps.getItemStack(1, Short.MAX_VALUE), new ItemStack(Items.field_151122_aG));
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerMail();
    }
}

