/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.api.IPaintableBlock;
import openblocks.common.Stencil;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityCanvas;
import openmods.infobook.BookDocumentation;
import openmods.utils.ColorUtils;

@BookDocumentation
public class BlockCanvas
extends OpenBlock
implements IPaintableBlock {
    public static final int RENDER_ALL_SIDES = -1;
    public static final int BASE_LAYER = -1;
    public static final int NO_LAYER = -2;
    private int layer = 0;
    private int renderSide = 0;
    public IIcon baseIcon;
    public IIcon wallpaper;

    public BlockCanvas() {
        this(Material.field_151583_m);
    }

    public BlockCanvas(Material material) {
        super(material);
    }

    public void func_149651_a(IIconRegister registry) {
        this.field_149761_L = this.baseIcon = registry.func_94245_a("openblocks:canvas");
        this.wallpaper = registry.func_94245_a("openblocks:wallpaper");
        for (Stencil stencil : Stencil.values()) {
            stencil.registerBlockIcons(registry);
        }
    }

    public void setLayerForRender(int layer) {
        this.layer = layer;
    }

    public void setSideForRender(int side) {
        this.renderSide = side;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return (this.renderSide == -1 || side == this.renderSide) && super.func_149646_a(world, x, y, z, side);
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile;
        if (this.layer != -2 && (tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityCanvas.class))) != null) {
            return tile.getColorForRender(this.renderSide, this.layer);
        }
        return -1;
    }

    public IIcon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile;
        if (this.layer != -2 && (tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityCanvas.class))) != null) {
            return tile.getTextureForRender(this.renderSide, this.layer);
        }
        return super.getUnrotatedTexture(direction, world, x, y, z);
    }

    public static void replaceBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block.func_149688_o() == Material.field_151592_s) {
            world.func_147449_b(x, y, z, (Block)OpenBlocks.Blocks.canvasGlass);
        } else {
            world.func_147449_b(x, y, z, (Block)OpenBlocks.Blocks.canvas);
        }
        TileEntityCanvas tile = (TileEntityCanvas)world.func_147438_o(x, y, z);
        tile.setPaintedBlockBlock(block, meta);
    }

    @Override
    public boolean recolourBlockRGB(World world, int x, int y, int z, ForgeDirection side, int color) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof TileEntityCanvas ? ((TileEntityCanvas)te).applyPaint(color, side) : false;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        ColorUtils.ColorMeta color = ColorUtils.vanillaBlockToColor((int)colour);
        return this.recolourBlockRGB(world, x, y, z, side, color.rgb);
    }
}

