/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import openblocks.common.entity.ai.EntityAIBreakBlock;
import openblocks.common.entity.ai.EntityAIPickupPlayer;
import openmods.Log;
import openmods.network.event.EventDirection;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventManager;
import openmods.network.event.NetworkEventMeta;
import openmods.utils.ByteUtils;
import openmods.utils.io.GameProfileSerializer;

public class EntityMiniMe
extends EntityCreature
implements IEntityAdditionalSpawnData {
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation locationSkin;
    private GameProfile owner;
    private int pickupCooldown = 0;
    private boolean wasRidden = false;

    public EntityMiniMe(World world, GameProfile owner) {
        this(world);
        this.owner = owner != null ? EntityMiniMe.fetchFullProfile(owner) : null;
    }

    public EntityMiniMe(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.95f);
        this.func_110163_bv();
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPickupPlayer(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIBreakBlock((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.pickupCooldown > 0) {
            --this.pickupCooldown;
        }
        if (this.wasRidden && this.field_70153_n == null) {
            this.wasRidden = false;
            this.setPickupCooldown(1200);
        } else if (this.field_70153_n != null) {
            this.wasRidden = true;
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O + 0.15;
    }

    public int getPickupCooldown() {
        return this.pickupCooldown;
    }

    public void setPickupCooldown(int cooldown) {
        this.pickupCooldown = cooldown;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getLocationSkin() {
        return (ResourceLocation)Objects.firstNonNull((Object)this.getResourceLocation(), (Object)AbstractClientPlayer.field_110314_b);
    }

    public void func_94058_c(String name) {
        super.func_94058_c(name);
        if (!(this.field_70170_p.field_72995_K || MinecraftServer.func_71276_C() == null || name == null || this.owner != null && name.equalsIgnoreCase(this.owner.getName()))) {
            try {
                GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(name);
                this.owner = profile != null ? EntityMiniMe.fetchFullProfile(profile) : null;
                this.propagateOwnerChange();
            }
            catch (Exception e) {
                Log.warn((Throwable)e, (String)"Failed to change skin to %s", (Object[])new Object[]{name});
            }
        }
    }

    private void propagateOwnerChange() {
        NetworkEventManager.INSTANCE.dispatcher().senders.entity.sendMessage((Object)new OwnerChangeEvent(this.func_145782_y(), this.owner), (Object)this);
    }

    private ResourceLocation getResourceLocation() {
        Minecraft minecraft;
        Map map;
        if (this.owner != null && (map = (minecraft = Minecraft.func_71410_x()).func_152342_ad().func_152788_a(this.owner)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture skin = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
            return minecraft.func_152342_ad().func_152792_a(skin, MinecraftProfileTexture.Type.SKIN);
        }
        return null;
    }

    private static GameProfile fetchFullProfile(GameProfile profile) {
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return property != null ? profile : MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(profile, true);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70631_g_() {
        return true;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.owner != null) {
            data.writeBoolean(true);
            try {
                GameProfileSerializer.write((GameProfile)this.owner, (DataOutput)new ByteBufOutputStream(data));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            data.writeBoolean(false);
        }
    }

    public void readSpawnData(ByteBuf data) {
        if (data.readBoolean()) {
            try {
                this.owner = GameProfileSerializer.read((DataInput)new ByteBufInputStream(data));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.owner != null) {
            NBTTagCompound ownerTag = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)ownerTag, (GameProfile)this.owner);
            tag.func_74782_a("Owner", (NBTBase)ownerTag);
        }
        tag.func_74768_a("pickupCooldown", this.pickupCooldown);
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.owner = EntityMiniMe.readOwner(tag);
        super.func_70037_a(tag);
        this.pickupCooldown = tag.func_74762_e("pickupCooldown");
    }

    private static GameProfile readOwner(NBTTagCompound tag) {
        if (tag.func_150297_b("owner", 8)) {
            String ownerName = tag.func_74779_i("owner");
            return MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(ownerName);
        }
        if (tag.func_150297_b("OwnerUUID", 8)) {
            String uuidStr = tag.func_74779_i("OwnerUUID");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                return new GameProfile(uuid, null);
            }
            catch (IllegalArgumentException e) {
                Log.warn((Throwable)e, (String)"Failed to parse UUID: %s", (Object[])new Object[]{uuidStr});
            }
        } else if (tag.func_150297_b("Owner", 10)) {
            return NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("Owner"));
        }
        return null;
    }

    public static class OwnerChangeHandler {
        @SubscribeEvent
        public void onProfileChange(OwnerChangeEvent evt) {
            World world = evt.sender.field_70170_p;
            Entity e = world.func_73045_a(evt.entityId);
            if (e instanceof EntityMiniMe) {
                ((EntityMiniMe)e).owner = evt.profile;
            }
        }
    }

    @NetworkEventMeta(direction=EventDirection.S2C, compressed=true)
    public static class OwnerChangeEvent
    extends NetworkEvent {
        private GameProfile profile;
        private int entityId;

        public OwnerChangeEvent(int entityId, GameProfile profile) {
            this.profile = profile;
            this.entityId = entityId;
        }

        protected void readFromStream(DataInput input) throws IOException {
            this.entityId = ByteUtils.readVLI((DataInput)input);
            if (input.readBoolean()) {
                this.profile = GameProfileSerializer.read((DataInput)input);
            }
        }

        protected void writeToStream(DataOutput output) throws IOException {
            ByteUtils.writeVLI((DataOutput)output, (int)this.entityId);
            if (this.profile != null) {
                output.writeBoolean(true);
                GameProfileSerializer.write((GameProfile)this.profile, (DataOutput)output);
            } else {
                output.writeBoolean(false);
            }
        }
    }
}

