/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import openblocks.Config;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlacerAwareTile;
import openmods.sync.SyncableByte;
import openmods.sync.SyncableFloat;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityFan
extends SyncedTileEntity
implements IPlacerAwareTile,
INeighbourAwareTile {
    private static final double CONE_HALF_APERTURE = 0.6;
    private SyncableFloat angle;
    private SyncableByte power;
    private float bladeRotation;
    private float bladeSpeed;

    protected void createSyncedFields() {
        this.angle = new SyncableFloat();
        this.power = new SyncableByte();
    }

    public void func_145845_h() {
        float redstonePower;
        this.bladeSpeed = redstonePower = (float)this.power.get() / 15.0f;
        this.bladeRotation += redstonePower;
        double maxForce = Config.fanForce * (double)redstonePower;
        if (maxForce <= 0.0) {
            return;
        }
        List entities = this.field_145850_b.func_72872_a(Entity.class, this.getEntitySearchBoundingBox());
        if (entities.isEmpty()) {
            return;
        }
        double angle = Math.toRadians(this.getAngle() - 90.0f);
        Vec3 blockPos = this.getConeApex(angle);
        Vec3 basePos = this.getConeBaseCenter(angle);
        Vec3 coneAxis = Vec3.func_72443_a((double)(basePos.field_72450_a - blockPos.field_72450_a), (double)(basePos.field_72448_b - blockPos.field_72448_b), (double)(basePos.field_72449_c - blockPos.field_72449_c));
        for (Entity entity : entities) {
            double distToOrigin;
            double force;
            Vec3 directionVec;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !TileEntityFan.isLyingInSphericalCone(coneAxis, directionVec = Vec3.func_72443_a((double)(entity.field_70165_t - blockPos.field_72450_a), (double)(entity.field_70163_u - blockPos.field_72448_b), (double)(entity.field_70161_v - blockPos.field_72449_c)), 0.6) || (force = (1.0 - (distToOrigin = directionVec.func_72433_c()) / Config.fanRange) * maxForce) <= 0.0) continue;
            Vec3 normal = directionVec.func_72432_b();
            entity.field_70159_w += force * normal.field_72450_a;
            entity.field_70179_y += force * normal.field_72449_c;
        }
    }

    private Vec3 getConeBaseCenter(double angle) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c + Math.cos(angle) * Config.fanRange), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + Math.sin(angle) * Config.fanRange));
    }

    private Vec3 getConeApex(double angle) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 - Math.cos(angle) * 1.1), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5 - Math.sin(angle) * 1.1));
    }

    private AxisAlignedBB getEntitySearchBoundingBox() {
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - 2), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
        return boundingBox.func_72314_b(Config.fanRange, Config.fanRange, Config.fanRange);
    }

    private static boolean isLyingInSphericalCone(Vec3 coneAxis, Vec3 originToTarget, double halfAperture) {
        double angleToAxisCos = originToTarget.func_72430_b(coneAxis) / originToTarget.func_72433_c() / coneAxis.func_72433_c();
        return angleToAxisCos > Math.cos(halfAperture);
    }

    public void onBlockPlacedBy(EntityLivingBase placer, ItemStack stack) {
        this.angle.set(placer.field_70759_as);
    }

    public float getAngle() {
        return this.angle.get();
    }

    public float getBladeRotation(float partialTickTime) {
        return this.bladeRotation + this.bladeSpeed * partialTickTime;
    }

    public void onNeighbourChanged(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            int power = Config.redstoneActivatedFan ? this.field_145850_b.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e) : 15;
            this.power.set((byte)power);
            this.sync();
        }
    }
}

