/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayDeque;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import toast.mobProperties.EffectHelper;
import toast.mobProperties.IProperty;
import toast.mobProperties.MobProperties;
import toast.mobProperties.entry.MobStatsInfo;

public class TickHandler {
    public static ArrayDeque<InitEntry> entityStack = new ArrayDeque();

    public TickHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !entityStack.isEmpty()) {
            InitEntry entry;
            int count = 10;
            while (count-- > 0 && (entry = entityStack.pollFirst()) != null) {
                entry.execute();
            }
        }
    }

    public static void markForInit(EntityLivingBase entity, MobProperties props) {
        entityStack.add(new InitEntry(entity, props));
    }

    private static class InitEntry {
        public final EntityLivingBase entity;
        public final IProperty props;

        public InitEntry(EntityLivingBase initEntity, MobProperties props) {
            this.entity = initEntity;
            this.props = props;
        }

        public void execute() {
            EffectHelper.loadStats(this.entity, false);
            if (EffectHelper.getInit((Entity)this.entity) > 0 || !this.entity.func_70089_S()) {
                return;
            }
            EffectHelper.setInit((Entity)this.entity, 1);
            MobStatsInfo mobStats = new MobStatsInfo(this.entity);
            this.props.init(mobStats);
            mobStats.save();
        }
    }
}

