/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.drops;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.Item;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.ItemStats;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.IPropertyDrops;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobDropsInfo;

public class EntryDropsAdd
extends EntryAbstract
implements IPropertyDrops {
    public final Item item;
    public final double[] damages;
    public final double[] counts;
    public final ItemStats itemStats;

    public EntryDropsAdd(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.item = FileHelper.readItem(node, path, "id");
        this.damages = FileHelper.readCounts(node, path, "damage", 0.0, 0.0);
        this.counts = FileHelper.readCounts(node, path, "count", 1.0, 1.0);
        this.itemStats = new ItemStats(path, root, index, node, loader);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"id"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"damage", "count", "item_stats"};
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        int damage = FileHelper.getCount(this.damages, mobDrops.random);
        int count = FileHelper.getCount(this.counts, mobDrops.random);
        mobDrops.addDrop(this.item, damage, count, this.itemStats);
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        dropsList.add(new DropEntry(this.item, this.damages, this.counts, attempts, chance, conditions));
    }
}

