/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.nbt;

import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.NBTStatsInfo;

public class EntryNBTChestLoot
extends EntryAbstract {
    private final String lootList;
    private final int inventorySize;
    private final String name;
    private final double[] counts;

    public EntryNBTChestLoot(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.name = FileHelper.readText(node, path, "name", "Items");
        this.lootList = FileHelper.readText(node, path, "loot", "dungeonChest");
        this.inventorySize = FileHelper.readInteger(node, path, "inventory_size", 27);
        double[] countsTmp = FileHelper.readCounts(node, path, "count", -1.0, -1.0);
        this.counts = (double[])(countsTmp[0] < 0.0 || countsTmp[1] < 0.0 ? null : countsTmp);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[0];
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"name", "loot", "inventory_size", "count"};
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        InventoryChestLoot chestProxy = new InventoryChestLoot(this.inventorySize);
        ChestGenHooks info = ChestGenHooks.getInfo((String)this.lootList);
        Random rand = nbtStats.theEntity.func_70681_au();
        int count = this.counts == null ? info.getCount(rand) : FileHelper.getCount(this.counts);
        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)chestProxy, (int)count);
        nbtStats.addTag(this.name, (NBTBase)chestProxy.writeToNBT());
    }

    private static class InventoryChestLoot
    implements IInventory {
        private ItemStack[] inventory;

        public InventoryChestLoot(int inventorySize) {
            this.inventory = new ItemStack[inventorySize];
        }

        public NBTTagList writeToNBT() {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tag);
                list.func_74742_a((NBTBase)tag);
            }
            return list;
        }

        public int func_70302_i_() {
            return this.inventory.length;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inventory[slot];
        }

        public void func_70299_a(int slot, ItemStack itemStack) {
            this.inventory[slot] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
        }

        public ItemStack func_70298_a(int slot, int count) {
            return null;
        }

        public ItemStack func_70304_b(int slot) {
            return null;
        }

        public String func_145825_b() {
            return "Chest";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer player) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int slot, ItemStack itemStack) {
            return true;
        }
    }
}

