/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.CatacombNode;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.catacomb.settings.CatacombSettingsResolver;
import greymerk.roguelike.catacomb.settings.ICatacombSettings;
import greymerk.roguelike.catacomb.tower.Tower;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class Catacomb {
    public static final int VERTICAL_SPACING = 10;
    public static final int TOPLEVEL = 50;
    public static CatacombSettingsResolver settingsResolver;

    public static void initResolver() {
        settingsResolver = new CatacombSettingsResolver();
    }

    public static void generateNear(World world, Random rand, int x, int z) {
        int attempts = 50;
        for (int i = 0; i < attempts; ++i) {
            Coord location = Catacomb.getNearbyCoord(rand, x, z, 40, 100);
            if (!Catacomb.validLocation(world, rand, location.getX(), location.getZ())) continue;
            ICatacombSettings setting = settingsResolver.getSettings(world, rand, location);
            if (setting == null) {
                return;
            }
            Catacomb.generate(world, setting, location.getX(), location.getZ());
            return;
        }
    }

    public static void generate(World world, ICatacombSettings settings, int inX, int inZ) {
        int x = inX;
        int y = 50;
        int z = inZ;
        Random rand = Catacomb.getRandom(world, inX, inZ);
        int numLevels = settings.getNumLevels();
        CatacombNode oldEnd = null;
        for (int i = 0; i < numLevels; ++i) {
            CatacombLevelSettings levelSettings = settings.getLevelSettings(i);
            rand = Catacomb.getRandom(world, x, z);
            CatacombLevel level = new CatacombLevel(world, rand, levelSettings, new Coord(x, y, z), levelSettings.getNumRooms(), levelSettings.getRange());
            while (!level.isDone()) {
                level.update();
            }
            level.generate(oldEnd);
            oldEnd = level.getEnd();
            x = oldEnd.getPosition().getX();
            y -= 10;
            z = oldEnd.getPosition().getZ();
        }
        Tower tower = settings.getTower().getTower();
        rand = Catacomb.getRandom(world, inX, inZ);
        Tower.get(tower).generate(world, rand, settings.getTower().getTheme(), inX, 50, inZ);
    }

    public static boolean canSpawnInChunk(int chunkX, int chunkZ, World world) {
        if (!RogueConfig.getBoolean(RogueConfig.DONATURALSPAWN)) {
            return false;
        }
        if (!RogueConfig.getIntList(RogueConfig.DIMENSIONWL).contains(world.field_73011_w.field_76574_g)) {
            return false;
        }
        int frequency = RogueConfig.getInt(RogueConfig.SPAWNFREQUENCY);
        int min = 8 * frequency / 10;
        int max = 32 * frequency / 10;
        min = min < 2 ? 2 : min;
        max = max < 8 ? 8 : max;
        int tempX = chunkX < 0 ? chunkX - (max - 1) : chunkX;
        int tempZ = chunkZ < 0 ? chunkZ - (max - 1) : chunkZ;
        int m = tempX / max;
        int n = tempZ / max;
        Random r = world.func_72843_D(m, n, 10387312);
        m *= max;
        n *= max;
        return chunkX == (m += r.nextInt(max - min)) && chunkZ == (n += r.nextInt(max - min));
    }

    public static void spawnInChunk(World world, Random rand, int chunkX, int chunkZ) {
        if (Catacomb.canSpawnInChunk(chunkX, chunkZ, world)) {
            int x = chunkX * 16 + 4;
            int z = chunkZ * 16 + 4;
            Catacomb.generateNear(world, rand, x, z);
        }
    }

    public static int getLevel(int y) {
        if (y < 15) {
            return 4;
        }
        if (y < 25) {
            return 3;
        }
        if (y < 35) {
            return 2;
        }
        if (y < 45) {
            return 1;
        }
        return 0;
    }

    public static boolean validLocation(World world, Random rand, int x, int z) {
        int y;
        if (!world.func_147437_c(x, 100, z)) {
            return false;
        }
        for (y = 100; !world.func_147439_a(x, y, z).func_149688_o().func_76218_k() && y > 50; --y) {
        }
        if (y < 60) {
            return false;
        }
        List<Coord> above = WorldGenPrimitive.getRectSolid(x - 4, y + 4, z - 4, x + 4, y + 4, z + 4);
        for (Coord c : above) {
            if (!world.func_147439_a(c.getX(), c.getY(), c.getZ()).func_149688_o().func_76218_k()) continue;
            return false;
        }
        List<Coord> below = WorldGenPrimitive.getRectSolid(x - 4, y - 3, z - 4, x + 4, y - 3, z + 4);
        int airCount = 0;
        for (Coord c : below) {
            if (!world.func_147439_a(c.getX(), c.getY(), c.getZ()).func_149688_o().func_76218_k()) {
                ++airCount;
            }
            if (airCount <= 8) continue;
            return false;
        }
        return true;
    }

    public static Coord getNearbyCoord(Random rand, int x, int z, int min, int max) {
        int distance = min + rand.nextInt(max - min);
        double angle = rand.nextDouble() * 2.0 * Math.PI;
        int xOffset = (int)(Math.cos(angle) * (double)distance);
        int zOffset = (int)(Math.sin(angle) * (double)distance);
        Coord nearby = new Coord(x + xOffset, 0, z + zOffset);
        return nearby;
    }

    public static Random getRandom(World world, int x, int z) {
        long seed = world.func_72905_C() * (long)x * (long)z;
        Random rand = new Random();
        rand.setSeed(seed);
        return rand;
    }

    static {
        Catacomb.initResolver();
    }
}

