/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.CatacombTunneler;
import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class CatacombNode {
    private World world;
    private Random rand;
    private CatacombLevel level;
    private List<CatacombTunneler> tunnelers;
    private Coord pos;
    private IDungeon toGenerate;
    private Cardinal direction;

    public CatacombNode(World world, Random rand, CatacombLevel level, ITheme theme, Coord origin) {
        this.world = world;
        this.rand = rand;
        this.level = level;
        this.pos = new Coord(origin);
        this.tunnelers = new ArrayList<CatacombTunneler>();
        this.direction = Cardinal.directions[rand.nextInt(Cardinal.directions.length)];
        if (this.level.inRange(origin.getX(), origin.getZ())) {
            this.spawnTunnelers();
        }
    }

    public CatacombNode(World world, Random rand, CatacombLevel level, ITheme theme, CatacombTunneler tunneler) {
        this.world = world;
        this.level = level;
        this.pos = tunneler.getPosition();
        this.rand = rand;
        this.tunnelers = new ArrayList<CatacombTunneler>();
        this.direction = Cardinal.reverse(tunneler.getDirection());
        if (this.level.inRange(this.pos.getX(), this.pos.getZ())) {
            this.spawnTunnelers();
        }
    }

    private void spawnTunnelers() {
        for (Cardinal dir : Cardinal.directions) {
            if (dir.equals((Object)this.direction) || this.level.nodeCount() != 0 && !this.tunnelers.isEmpty() && !this.rand.nextBoolean()) continue;
            this.tunnelers.add(new CatacombTunneler(this.world, this.rand, this.level, dir, this.pos));
        }
    }

    public void update() {
        for (CatacombTunneler tunneler : this.tunnelers) {
            tunneler.update();
        }
    }

    public boolean isDone() {
        for (CatacombTunneler tunneler : this.tunnelers) {
            if (tunneler.isDone()) continue;
            return false;
        }
        return true;
    }

    public void construct(World world) {
        for (CatacombTunneler tunneler : this.tunnelers) {
            if (!tunneler.isDone()) continue;
            tunneler.construct(world);
        }
    }

    public void segments() {
        for (CatacombTunneler tunneler : this.tunnelers) {
            if (!tunneler.isDone()) continue;
            tunneler.addSegments(this.world);
        }
    }

    public void setDungeon(IDungeon toGenerate) {
        this.toGenerate = toGenerate;
    }

    public int getSize() {
        if (this.toGenerate == null) {
            return 6;
        }
        return this.toGenerate.getSize();
    }

    public Cardinal[] getEntrances() {
        ArrayList<Cardinal> dirs = new ArrayList<Cardinal>();
        dirs.add(this.direction);
        for (CatacombTunneler tunneler : this.tunnelers) {
            if (!tunneler.isDone()) continue;
            dirs.add(tunneler.getDirection());
        }
        return dirs.toArray(new Cardinal[dirs.size()]);
    }

    public Coord getPosition() {
        return new Coord(this.pos);
    }
}

