/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon;

import greymerk.roguelike.catacomb.dungeon.Dungeon;
import greymerk.roguelike.catacomb.dungeon.IDungeon;
import greymerk.roguelike.util.IWeighted;
import java.util.Random;

public class DungeonWeightedChoice
implements IWeighted<Dungeon>,
Comparable<IWeighted<?>> {
    Dungeon type;
    int chance;

    public DungeonWeightedChoice(Dungeon type, int chance) {
        this.type = type;
        this.chance = chance;
    }

    public boolean choose(Random rand) {
        return rand.nextInt(this.chance) == 0;
    }

    public IDungeon getInstance() {
        return Dungeon.getInstance(this.type);
    }

    @Override
    public int compareTo(IWeighted<?> other) {
        if (this.chance < other.getWeight()) {
            return -1;
        }
        if (this.chance > other.getWeight()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getWeight() {
        return this.chance;
    }

    @Override
    public Dungeon get(Random rand) {
        return this.type;
    }
}

