/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.catacomb.dungeon.Dungeon;
import greymerk.roguelike.catacomb.dungeon.ISecretRoom;
import greymerk.roguelike.catacomb.dungeon.SecretRoom;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;

public class SecretFactory
implements ISecretRoom {
    private int count;
    private List<ISecretRoom> secrets;

    public SecretFactory() {
        this.count = 0;
        this.secrets = new ArrayList<ISecretRoom>();
    }

    public SecretFactory(SecretFactory toCopy) {
        this.secrets = new ArrayList<ISecretRoom>();
        this.count = toCopy.count;
        for (ISecretRoom room : toCopy.secrets) {
            ISecretRoom toAdd = room instanceof SecretFactory ? new SecretFactory((SecretFactory)room) : new SecretRoom((SecretRoom)room);
            this.secrets.add(toAdd);
        }
    }

    public SecretFactory(JsonArray data) {
        this.secrets = new ArrayList<ISecretRoom>();
        for (JsonElement e : data) {
            JsonObject room = e.getAsJsonObject();
            String type = room.get("type").getAsString();
            int num = room.get("num").getAsInt();
            this.count += num;
            this.secrets.add(new SecretRoom(Dungeon.valueOf(type), num));
        }
    }

    public void addRoom(Dungeon type) {
        this.addRoom(type, 1);
    }

    public void addRoom(Dungeon type, int count) {
        this.secrets.add(new SecretRoom(type, count));
        this.count += count;
    }

    public void addRoom(List<Dungeon> rooms, int count) {
        SecretFactory toAdd = new SecretFactory();
        for (Dungeon type : rooms) {
            toAdd.addRoom(type);
        }
        this.secrets.add(toAdd);
        this.count += count;
    }

    @Override
    public boolean genRoom(World world, Random rand, CatacombLevelSettings settings, Cardinal dir, Coord pos) {
        if (this.count <= 0) {
            return false;
        }
        Collections.shuffle(this.secrets, rand);
        for (ISecretRoom room : this.secrets) {
            if (!room.genRoom(world, rand, settings, dir, pos)) continue;
            --this.count;
            return true;
        }
        return false;
    }
}

