/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.dungeon.room;

import greymerk.roguelike.catacomb.dungeon.DungeonBase;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class DungeonsFire
extends DungeonBase {
    @Override
    public boolean generate(World world, Random rand, CatacombLevelSettings settings, Cardinal[] entrances, Coord origin) {
        ITheme theme = settings.getTheme();
        IBlockFactory wall = theme.getPrimaryWall();
        MetaBlock stair = theme.getPrimaryStair();
        IBlockFactory pillar = theme.getPrimaryPillar();
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        start.add(Cardinal.NORTH, 8);
        start.add(Cardinal.WEST, 8);
        start.add(Cardinal.DOWN);
        end = new Coord(origin);
        end.add(Cardinal.SOUTH, 8);
        end.add(Cardinal.EAST, 8);
        end.add(Cardinal.UP, 7);
        WorldGenPrimitive.fillRectHollow(world, rand, start, end, wall, false, true);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor;
            for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
                start = new Coord(origin);
                start.add(dir, 7);
                start.add(orth, 2);
                end = new Coord(start);
                end.add(Cardinal.UP, 6);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, pillar, true, true);
                cursor = new Coord(origin);
                cursor.add(dir, 8);
                cursor.add(orth);
                cursor.add(Cardinal.UP, 2);
                WorldGenPrimitive.setBlock(world, rand, cursor, WorldGenPrimitive.blockOrientation(stair, Cardinal.reverse(orth), true), true, false);
                cursor.add(Cardinal.reverse(dir));
                cursor.add(Cardinal.UP);
                WorldGenPrimitive.blockOrientation(stair, Cardinal.reverse(orth), true).setBlock(world, cursor);
                start = new Coord(cursor);
                start.add(Cardinal.UP);
                end = new Coord(start);
                end.add(Cardinal.UP, 3);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, pillar, true, true);
                cursor.add(Cardinal.reverse(dir));
                cursor.add(orth);
                WorldGenPrimitive.blockOrientation(stair, Cardinal.reverse(dir), true).setBlock(world, cursor);
                start = new Coord(cursor);
                start.add(Cardinal.UP);
                end = new Coord(start);
                end.add(Cardinal.UP, 3);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, pillar, true, true);
                cursor.add(dir);
                cursor.add(orth);
                WorldGenPrimitive.blockOrientation(stair, orth, true).setBlock(world, cursor);
                start = new Coord(cursor);
                start.add(Cardinal.UP);
                end = new Coord(start);
                end.add(Cardinal.UP, 3);
                WorldGenPrimitive.fillRectSolid(world, rand, start, end, pillar, true, true);
            }
            cursor = new Coord(origin);
            cursor.add(dir, 6);
            cursor.add(Cardinal.getOrthogonal(dir)[0], 6);
            DungeonsFire.genFire(world, rand, theme, cursor);
            cursor = new Coord(origin);
            cursor.add(Cardinal.UP, 4);
            cursor.add(dir);
            start = new Coord(cursor);
            end = new Coord(cursor);
            end.add(dir, 6);
            WorldGenPrimitive.fillRectSolid(world, rand, start, end, wall, true, true);
            cursor.add(Cardinal.getOrthogonal(dir)[0]);
            WorldGenPrimitive.setBlock(world, rand, cursor, wall, true, true);
            start = new Coord(end);
            end.add(Cardinal.UP, 2);
            end.add(Cardinal.reverse(dir));
            WorldGenPrimitive.fillRectSolid(world, rand, start, end, wall, true, true);
            Cardinal[] orth = Cardinal.getOrthogonal(dir);
            WorldGenPrimitive.blockOrientation(stair, Cardinal.reverse(dir), true);
            cursor = new Coord(end);
            start = new Coord(cursor);
            start.add(orth[0], 3);
            end.add(orth[1], 3);
            WorldGenPrimitive.fillRectSolid(world, rand, start, end, wall, true, false);
            start = new Coord(cursor);
            start.add(Cardinal.DOWN);
            end = new Coord(start);
            start.add(orth[0], 3);
            end.add(orth[1], 3);
            WorldGenPrimitive.fillRectSolid(world, rand, start, end, stair, true, false);
            start = new Coord(cursor);
            start.add(Cardinal.reverse(dir));
            end = new Coord(start);
            start.add(orth[0], 3);
            end.add(orth[1], 3);
            WorldGenPrimitive.fillRectSolid(world, rand, start, end, stair, true, false);
        }
        return false;
    }

    public static void genFire(World world, Random rand, ITheme theme, Coord origin) {
        Coord end;
        Coord start;
        IBlockFactory wall = theme.getPrimaryWall();
        IBlockFactory pillar = theme.getPrimaryPillar();
        MetaBlock stair = theme.getPrimaryStair();
        Coord cursor = new Coord(origin);
        WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150424_aL);
        cursor.add(Cardinal.UP);
        WorldGenPrimitive.setBlock(world, cursor, (Block)Blocks.field_150480_ab);
        for (Cardinal dir : Cardinal.directions) {
            Cardinal[] orth = Cardinal.getOrthogonal(dir);
            start = new Coord(origin);
            start.add(dir);
            start.add(orth[0]);
            end = new Coord(start);
            end.add(Cardinal.UP, 2);
            WorldGenPrimitive.fillRectSolid(world, rand, start, end, pillar, true, false);
            cursor = new Coord(origin);
            cursor.add(dir);
            WorldGenPrimitive.setBlock(world, rand, cursor, WorldGenPrimitive.blockOrientation(stair, dir, false), true, false);
            cursor.add(Cardinal.UP);
            WorldGenPrimitive.setBlock(world, cursor, Blocks.field_150411_aY);
            cursor.add(Cardinal.UP);
            WorldGenPrimitive.setBlock(world, rand, cursor, WorldGenPrimitive.blockOrientation(stair, dir, true), true, false);
            cursor = new Coord(origin);
            cursor.add(Cardinal.UP, 6);
            cursor.add(dir, 3);
            for (Cardinal o : Cardinal.getOrthogonal(dir)) {
                Coord c = new Coord(cursor);
                c.add(o, 2);
                WorldGenPrimitive.setBlock(world, rand, c, WorldGenPrimitive.blockOrientation(stair, dir, true), true, false);
                c.add(o);
                WorldGenPrimitive.setBlock(world, rand, c, WorldGenPrimitive.blockOrientation(stair, dir, true), true, false);
            }
            cursor = new Coord(origin);
            cursor.add(Cardinal.UP);
            cursor.add(dir, 2);
            if (!world.func_147437_c(cursor.getX(), cursor.getY(), cursor.getZ())) continue;
            start = new Coord(origin);
            start.add(Cardinal.UP, 3);
            start.add(dir, 2);
            end = new Coord(start);
            start.add(orth[0], 2);
            end.add(orth[1], 2);
            WorldGenPrimitive.blockOrientation(stair, dir, true);
            WorldGenPrimitive.fillRectSolid(world, rand, start, end, stair, true, false);
        }
        start = new Coord(origin);
        start.add(Cardinal.UP, 3);
        start.add(Cardinal.NORTH, 2);
        start.add(Cardinal.WEST, 2);
        end = new Coord(origin);
        end.add(Cardinal.UP, 7);
        end.add(Cardinal.SOUTH, 2);
        end.add(Cardinal.EAST, 2);
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, wall, true, false);
    }

    @Override
    public int getSize() {
        return 10;
    }
}

