/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.catacomb.segment.part;

import greymerk.roguelike.catacomb.CatacombLevel;
import greymerk.roguelike.catacomb.segment.part.SegmentBase;
import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SegmentNetherArch
extends SegmentBase {
    @Override
    protected void genWall(World world, Random rand, CatacombLevel level, Cardinal dir, ITheme theme, int x, int y, int z) {
        Coord cursor;
        MetaBlock step = theme.getSecondaryStair();
        step.setMeta(WorldGenPrimitive.blockOrientation(Cardinal.reverse(dir), true));
        IBlockFactory pillar = theme.getSecondaryPillar();
        boolean hasLava = rand.nextInt(5) == 0;
        for (Cardinal orth : Cardinal.getOrthogonal(dir)) {
            cursor = new Coord(x, y, z);
            cursor.add(dir, 1);
            cursor.add(orth, 1);
            cursor.add(Cardinal.UP, 2);
            WorldGenPrimitive.setBlock(world, rand, cursor, step, true, true);
            cursor = new Coord(x, y, z);
            cursor.add(dir, 2);
            cursor.add(orth, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, pillar, true, true);
            cursor.add(Cardinal.UP, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, pillar, true, true);
        }
        MetaBlock fence = new MetaBlock(Blocks.field_150386_bk);
        MetaBlock lava = new MetaBlock((Block)Blocks.field_150356_k);
        cursor = new Coord(x, y, z);
        cursor.add(dir, 2);
        WorldGenPrimitive.setBlock(world, rand, cursor, fence, true, true);
        cursor.add(Cardinal.UP, 1);
        WorldGenPrimitive.setBlock(world, rand, cursor, fence, true, true);
        if (hasLava) {
            cursor.add(dir, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, lava, true, true);
            cursor.add(Cardinal.DOWN, 1);
            WorldGenPrimitive.setBlock(world, rand, cursor, lava, true, true);
        }
    }
}

