/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.citadel;

import greymerk.roguelike.catacomb.theme.ITheme;
import greymerk.roguelike.citadel.Citadel;
import greymerk.roguelike.citadel.CitadelTower;
import greymerk.roguelike.util.mst.Edge;
import greymerk.roguelike.util.mst.MinimumSpanningTree;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.WorldGenPrimitive;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class CityGrounds {
    public static void generate(World world, Random rand, MinimumSpanningTree mst, ITheme theme, Coord pos) {
        Coord start = new Coord(pos);
        start.add(new Coord(-51, 10, -51));
        Coord end = new Coord(pos);
        end.add(new Coord(51, 40, 51));
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, new MetaBlock(Blocks.field_150350_a), true, true);
        start = new Coord(pos);
        start.add(new Coord(-51, 10, -51));
        end = new Coord(pos);
        end.add(new Coord(51, 20, 51));
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, theme.getPrimaryWall(), true, true);
        start = new Coord(pos);
        start.add(new Coord(-34, 20, -34));
        end = new Coord(pos);
        end.add(new Coord(34, 30, 34));
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, theme.getPrimaryWall(), true, true);
        start = new Coord(pos);
        start.add(new Coord(-17, 30, -17));
        end = new Coord(pos);
        end.add(new Coord(17, 40, 17));
        WorldGenPrimitive.fillRectSolid(world, rand, start, end, theme.getPrimaryWall(), true, true);
        CitadelTower tower = new CitadelTower();
        Coord cursor = new Coord(pos);
        cursor.add(Cardinal.UP, 20);
        for (Edge e : mst.getEdges()) {
            start = e.getPoints()[0].getPosition();
            start.add(cursor);
            end = e.getPoints()[1].getPosition();
            end.add(cursor);
            end.add(Cardinal.DOWN, 20);
            WorldGenPrimitive.fillRectSolid(world, rand, start, end, theme.getPrimaryWall(), true, true);
        }
        List<Coord> towers = mst.getPointPositions();
        for (Coord c : towers) {
            c.add(pos);
            rand = Citadel.getRandom(world, c.getX(), c.getZ());
            tower.generate(world, rand, c.getX(), 50, c.getZ());
        }
    }
}

