/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.catacomb.Catacomb;
import greymerk.roguelike.catacomb.settings.CatacombLevelSettings;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.TreasureChestArmour;
import greymerk.roguelike.treasure.TreasureChestBlocks;
import greymerk.roguelike.treasure.TreasureChestEnchanting;
import greymerk.roguelike.treasure.TreasureChestFood;
import greymerk.roguelike.treasure.TreasureChestMusic;
import greymerk.roguelike.treasure.TreasureChestOre;
import greymerk.roguelike.treasure.TreasureChestPotions;
import greymerk.roguelike.treasure.TreasureChestReward;
import greymerk.roguelike.treasure.TreasureChestSmithy;
import greymerk.roguelike.treasure.TreasureChestSpecialty;
import greymerk.roguelike.treasure.TreasureChestStarter;
import greymerk.roguelike.treasure.TreasureChestSupplies;
import greymerk.roguelike.treasure.TreasureChestTools;
import greymerk.roguelike.treasure.TreasureChestWeapons;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public enum TreasureChest {
    ARMOUR,
    WEAPONS,
    BLOCKS,
    ENCHANTING,
    FOOD,
    ORE,
    POTIONS,
    STARTER,
    TOOLS,
    SUPPLIES,
    SMITH,
    MUSIC,
    SPECIAL,
    REWARD;

    public static final List<TreasureChest> level0;
    public static final List<TreasureChest> level1;
    public static final List<TreasureChest> level2;
    public static final List<TreasureChest> level3;
    public static final List<TreasureChest> level4;

    private static ITreasureChest getChest(TreasureChest type) {
        switch (type) {
            case ARMOUR: {
                return new TreasureChestArmour();
            }
            case WEAPONS: {
                return new TreasureChestWeapons();
            }
            case BLOCKS: {
                return new TreasureChestBlocks();
            }
            case ENCHANTING: {
                return new TreasureChestEnchanting();
            }
            case FOOD: {
                return new TreasureChestFood();
            }
            case ORE: {
                return new TreasureChestOre();
            }
            case POTIONS: {
                return new TreasureChestPotions();
            }
            case STARTER: {
                return new TreasureChestStarter();
            }
            case TOOLS: {
                return new TreasureChestTools();
            }
            case SUPPLIES: {
                return new TreasureChestSupplies();
            }
            case SMITH: {
                return new TreasureChestSmithy();
            }
            case MUSIC: {
                return new TreasureChestMusic();
            }
            case SPECIAL: {
                return new TreasureChestSpecialty();
            }
            case REWARD: {
                return new TreasureChestReward();
            }
        }
        return new TreasureChestFood();
    }

    public static void generate(World world, Random rand, CatacombLevelSettings settings, Coord pos, int level, boolean trapped) {
        TreasureChest type = TreasureChest.getChestType(rand, level);
        ITreasureChest chest = TreasureChest.getChest(type);
        chest.generate(world, rand, settings.getLoot(), pos, level, trapped);
    }

    public static void generate(World world, Random rand, CatacombLevelSettings settings, Coord pos) {
        TreasureChest.generate(world, rand, settings, pos, settings.getDifficulty(pos), false);
    }

    public static void generate(World world, Random rand, CatacombLevelSettings settings, Coord pos, TreasureChest type, boolean trapped) {
        TreasureChest.generate(world, rand, settings, pos, settings.getDifficulty(pos), trapped);
    }

    public static void generate(World world, Random rand, CatacombLevelSettings settings, Coord pos, TreasureChest type) {
        TreasureChest.generate(world, rand, settings, pos, type, Catacomb.getLevel(pos.getY()), false);
    }

    public static void generate(World world, Random rand, CatacombLevelSettings settings, Coord pos, TreasureChest type, int level, boolean trapped) {
        ITreasureChest chest = TreasureChest.getChest(type);
        chest.generate(world, rand, settings.getLoot(), pos, level, trapped);
    }

    public static void generate(World world, Random rand, CatacombLevelSettings settings, List<Coord> space, TreasureChest type) {
        TreasureChest.createChests(world, rand, settings, 1, space, new ArrayList<TreasureChest>(Arrays.asList(type)));
    }

    public static void createChests(World world, Random rand, CatacombLevelSettings settings, int numChests, List<Coord> space) {
        TreasureChest.createChests(world, rand, settings, numChests, space, false);
    }

    public static void createChests(World world, Random rand, CatacombLevelSettings settings, int numChests, List<Coord> space, boolean trapped) {
        Collections.shuffle(space, rand);
        int count = 0;
        for (Coord block : space) {
            if (count == numChests) break;
            if (!TreasureChest.isValidChestSpace(world, block)) continue;
            TreasureChest.generate(world, rand, settings, block, TreasureChest.getChestType(rand, Catacomb.getLevel(block.getY())));
            ++count;
        }
    }

    public static void createChests(World world, Random rand, CatacombLevelSettings settings, int numChests, List<Coord> space, List<TreasureChest> types) {
        Collections.shuffle(space, rand);
        int count = 0;
        for (Coord block : space) {
            if (count == numChests) break;
            if (!TreasureChest.isValidChestSpace(world, block)) continue;
            TreasureChest.generate(world, rand, settings, block, types.get(rand.nextInt(types.size())));
            ++count;
        }
    }

    private static TreasureChest getChestType(Random rand, int level) {
        switch (level) {
            case 0: {
                if (rand.nextInt(30) == 0) {
                    return ENCHANTING;
                }
                if (rand.nextInt(10) == 0) {
                    return SUPPLIES;
                }
                return level0.get(rand.nextInt(level0.size()));
            }
            case 1: {
                if (rand.nextInt(20) == 0) {
                    return ENCHANTING;
                }
                return level1.get(rand.nextInt(level1.size()));
            }
            case 2: {
                if (rand.nextInt(10) == 0) {
                    return ENCHANTING;
                }
                return level2.get(rand.nextInt(level2.size()));
            }
            case 3: {
                if (rand.nextInt(10) == 0) {
                    return ENCHANTING;
                }
                return level3.get(rand.nextInt(level3.size()));
            }
            case 4: {
                if (rand.nextInt(10) == 0) {
                    return ENCHANTING;
                }
                return level4.get(rand.nextInt(level4.size()));
            }
        }
        return FOOD;
    }

    public static boolean isValidChestSpace(World world, Coord pos) {
        if (!world.func_147437_c(pos.getX(), pos.getY(), pos.getZ())) {
            return false;
        }
        Coord cursor = new Coord(pos);
        cursor.add(Cardinal.DOWN);
        if (!world.func_147439_a(cursor.getX(), cursor.getY(), cursor.getZ()).func_149688_o().func_76220_a()) {
            return false;
        }
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(pos);
            cursor.add(dir);
            if (world.func_147439_a(cursor.getX(), cursor.getY(), cursor.getZ()) != Blocks.field_150486_ae) continue;
            return false;
        }
        return true;
    }

    static {
        level0 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS, FOOD));
        level1 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS, FOOD));
        level2 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS));
        level3 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS));
        level4 = new ArrayList<TreasureChest>(Arrays.asList(ORE, TOOLS, ARMOUR, WEAPONS));
    }
}

