/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.InventorySlot;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.LootSettings;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.MetaBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;

public abstract class TreasureChestBase
implements ITreasureChest,
Iterable<InventorySlot> {
    protected World world;
    protected Random rand;
    protected TileEntityChest chest;
    private static final int CHEST_MAX = 27;
    private List<InventorySlot> slots = new ArrayList<InventorySlot>();

    public TreasureChestBase() {
        for (int i = 0; i < 27; ++i) {
            this.slots.add(new InventorySlot(i, this));
        }
    }

    @Override
    public ITreasureChest generate(World world, Random rand, LootSettings loot, Coord pos, int level, boolean trapped) {
        this.world = world;
        this.rand = rand;
        Collections.shuffle(this.slots, rand);
        MetaBlock chestType = new MetaBlock((Block)(trapped ? Blocks.field_150447_bR : Blocks.field_150486_ae));
        if (!chestType.setBlock(world, pos)) {
            return null;
        }
        this.chest = (TileEntityChest)world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
        try {
            this.fillChest(this.chest, loot, level);
            int amount = RogueConfig.getBoolean(RogueConfig.GENEROUS) ? 12 : 6;
            Iterator<InventorySlot> slots = this.iterator();
            while (slots.hasNext() && amount > 0) {
                InventorySlot slot = slots.next();
                if (!slot.empty()) continue;
                slot.set(loot.get(Loot.JUNK, rand));
                --amount;
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return this;
    }

    @Override
    public boolean setInventorySlot(ItemStack item, int slot) {
        try {
            this.chest.func_70299_a(slot, item);
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean slotEmpty(int slot) {
        return this.chest.func_70301_a(slot) == null;
    }

    @Override
    public int getInventorySize() {
        if (this.chest == null) {
            return 1;
        }
        try {
            return this.chest.func_70302_i_();
        }
        catch (NullPointerException e) {
            return 1;
        }
    }

    @Override
    public Iterator<InventorySlot> iterator() {
        return this.slots.iterator();
    }

    protected abstract void fillChest(TileEntityChest var1, LootSettings var2, int var3);
}

