/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.Potion;
import greymerk.roguelike.treasure.loot.PotionEffect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;

public enum PotionMixture {
    TEQUILA,
    LAUDANUM,
    MOONSHINE,
    ABSINTHE,
    STOUT,
    VILE;


    public static ItemStack getPotion(Random rand, PotionMixture type) {
        switch (type) {
            case TEQUILA: {
                ItemStack potion = Potion.getSpecific(rand, Potion.FIRERESIST, false, false, false);
                int duration = 1000 + rand.nextInt(2000);
                PotionEffect.addCustomEffect(potion, PotionEffect.STRENGTH, 3, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.FATIGUE, 1, duration);
                Loot.setItemName(potion, "Tequila");
                return potion;
            }
            case LAUDANUM: {
                ItemStack potion = Potion.getSpecific(rand, Potion.STRENGTH, false, false, false);
                int duration = 200;
                PotionEffect.addCustomEffect(potion, PotionEffect.REGEN, 2, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.WEAKNESS, 2, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.SLOWNESS, 2, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.FATIGUE, 2, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.NAUSIA, 0, duration);
                Loot.setItemName(potion, "Laudanum");
                return potion;
            }
            case MOONSHINE: {
                ItemStack potion = Potion.getSpecific(rand, Potion.WEAKNESS, false, false, false);
                int duration = 1000 + rand.nextInt(2000);
                PotionEffect.addCustomEffect(potion, PotionEffect.DAMAGE, 2, 1);
                PotionEffect.addCustomEffect(potion, PotionEffect.BLINDNESS, 1, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.RESISTANCE, 2, duration);
                Loot.setItemName(potion, "Moonshine");
                return potion;
            }
            case ABSINTHE: {
                ItemStack potion = Potion.getSpecific(rand, Potion.POISON, false, false, false);
                int duration = 1000 + rand.nextInt(2000);
                PotionEffect.addCustomEffect(potion, PotionEffect.POISON, 1, 200 + rand.nextInt(300));
                PotionEffect.addCustomEffect(potion, PotionEffect.NIGHTVISION, 1, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.JUMP, 2, duration);
                Loot.setItemName(potion, "Absinthe");
                return potion;
            }
            case STOUT: {
                ItemStack potion = Potion.getSpecific(rand, Potion.HARM, false, false, false);
                int duration = 2000 + rand.nextInt(2000);
                PotionEffect.addCustomEffect(potion, PotionEffect.REGEN, 1, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.FATIGUE, 1, duration);
                PotionEffect.addCustomEffect(potion, PotionEffect.HEALTHBOOST, 2, duration);
                Loot.setItemName(potion, "Stout");
                return potion;
            }
            case VILE: {
                ItemStack potion = Potion.getSpecific(rand, Potion.HARM);
                PotionMixture.addRandomEffects(rand, potion, 2 + rand.nextInt(2));
                Loot.setItemName(potion, "Vile Mixture");
                return potion;
            }
        }
        return null;
    }

    public static ItemStack getBooze(Random rand) {
        PotionMixture[] booze = new PotionMixture[]{TEQUILA, LAUDANUM, MOONSHINE, ABSINTHE, STOUT};
        List<PotionMixture> potions = Arrays.asList(booze);
        int choice = rand.nextInt(potions.size());
        PotionMixture type = potions.get(choice);
        return PotionMixture.getPotion(rand, type);
    }

    public static ItemStack getRandom(Random rand) {
        List<PotionMixture> potions = Arrays.asList(PotionMixture.values());
        int choice = rand.nextInt(potions.size());
        PotionMixture type = potions.get(choice);
        return PotionMixture.getPotion(rand, type);
    }

    public static void addRandomEffects(Random rand, ItemStack potion, int numEffects) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>(Arrays.asList(PotionEffect.values()));
        Collections.shuffle(effects, rand);
        for (int i = 0; i < numEffects; ++i) {
            int duration;
            PotionEffect type = (PotionEffect)((Object)effects.get(i));
            switch (type) {
                case SATURATION: 
                case HEALTH: 
                case DAMAGE: {
                    duration = 1;
                    break;
                }
                case REGEN: {
                    duration = 200 + rand.nextInt(400);
                    break;
                }
                case HUNGER: {
                    duration = 100 + rand.nextInt(400);
                    break;
                }
                case WITHER: 
                case POISON: {
                    duration = 100 + rand.nextInt(200);
                    break;
                }
                default: {
                    duration = 1000 + rand.nextInt(2000);
                }
            }
            PotionEffect.addCustomEffect(potion, type, rand.nextInt(3), duration);
        }
    }
}

