/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.util.mst;

import greymerk.roguelike.util.mst.Edge;
import greymerk.roguelike.util.mst.Point;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Graph {
    protected List<Point> points = new ArrayList<Point>();
    protected List<Edge> edges;

    public Graph(Random rand, int size, int edgeLength) {
        int offset = size / 2 * edgeLength;
        for (int i = 0; i < size; ++i) {
            Coord temp = new Coord(0, 0, 0);
            temp.add(Cardinal.NORTH, offset);
            temp.add(Cardinal.WEST, offset);
            temp.add(Cardinal.SOUTH, edgeLength * i);
            for (int j = 0; j < size; ++j) {
                this.points.add(new Point(new Coord(temp), rand));
                temp.add(Cardinal.EAST, edgeLength);
            }
        }
        this.edges = new ArrayList<Edge>();
        for (Point p : this.points) {
            for (Point o : this.points) {
                if (p.equals(o)) continue;
                this.edges.add(new Edge(p, o));
            }
        }
    }

    public List<Coord> getPointPositions() {
        ArrayList<Coord> positions = new ArrayList<Coord>();
        for (Point p : this.points) {
            Coord toAdd = p.getPosition();
            positions.add(toAdd);
        }
        return positions;
    }
}

