/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import magicbees.bees.Allele;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;

public abstract class AlleleEffect
extends Allele
implements IAlleleBeeEffect {
    protected int throttle;
    protected boolean combinable;

    public AlleleEffect(String id, boolean isDominant, int timeout) {
        super("effect" + id, isDominant);
        this.throttle = timeout;
        this.combinable = false;
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public AlleleEffect setIsCombinable(boolean canCombine) {
        this.combinable = canCombine;
        return this;
    }

    public abstract IEffectData validateStorage(IEffectData var1);

    public final IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int count = storedData.getInteger(0);
        if (count >= this.throttle) {
            storedData = this.doEffectThrottled(genome, storedData, housing);
        } else {
            storedData.setInteger(0, count + 1);
        }
        return storedData;
    }

    protected abstract IEffectData doEffectThrottled(IBeeGenome var1, IEffectData var2, IBeeHousing var3);

    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        return Allele.forestryBaseEffect.doFX(genome, storedData, housing);
    }

    protected List<Entity> getEntitiesWithinRange(IBeeGenome genome, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        int[] min = new int[3];
        int[] max = new int[3];
        min[0] = housing.getXCoord() - area[0] / 2;
        max[0] = housing.getXCoord() + area[0] / 2;
        min[1] = housing.getYCoord() - area[1] / 2;
        max[1] = housing.getYCoord() + area[1] / 2;
        min[2] = housing.getZCoord() - area[2] / 2;
        max[2] = housing.getZCoord() + area[2] / 2;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
        return housing.getWorld().func_72872_a(EntityPlayer.class, bounds);
    }
}

