/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.effect;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import magicbees.bees.AlleleEffect;
import magicbees.bees.EffectData;
import magicbees.bees.allele.effect.TransmutationEffectController;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class AlleleEffectTransmuting
extends AlleleEffect {
    private TransmutationEffectController transmutationController;

    public AlleleEffectTransmuting(String id, boolean isDominant, TransmutationEffectController effectController, int timeoutBeeTicks) {
        super(id, isDominant, timeoutBeeTicks);
        this.transmutationController = effectController;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        int xRange = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[0]);
        int yRange = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[1]);
        int zRange = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[2]);
        int xCoord = housing.getXCoord() + world.field_73012_v.nextInt(xRange) - xRange / 2;
        int yCoord = housing.getYCoord() + world.field_73012_v.nextInt(yRange) - yRange / 2;
        int zCoord = housing.getZCoord() + world.field_73012_v.nextInt(zRange) - zRange / 2;
        BiomeGenBase biome = world.func_72807_a(xCoord, zCoord);
        this.transmutationController.attemptTransmutations(world, biome, new ItemStack(world.func_147439_a(xCoord, yCoord, zCoord), 1, world.func_72805_g(xCoord, yCoord, zCoord)), xCoord, yCoord, zCoord);
        storedData.setInteger(0, 0);
        return storedData;
    }
}

