/*
 * Decompiled with CFR 0.152.
 */
package magicbees.item;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import magicbees.main.Config;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.TabMagicBees;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMysteriousMagnet
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    private final float FUDGE_FACTOR = 0.2f;

    public ItemMysteriousMagnet() {
        this.setNoRepair();
        this.func_77627_a(true);
        this.func_77655_b("magicbees:mysteriousMagnet");
        this.func_77637_a(TabMagicBees.tabMagicBees);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        String s = LocalizationManager.getLocalizedString("misc.level", itemStack.func_77960_j() >> 1);
        if (this.isMagnetActive(itemStack)) {
            list.add(LocalizationManager.getLocalizedString("misc.magnetActive", s));
        } else {
            list.add(LocalizationManager.getLocalizedString("misc.magnetInactive", s));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i <= this.getMaximumLevel(); ++i) {
            list.add(new ItemStack((Item)this, 1, i * 2));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("magicbees:magnetInactive");
        this.activeIcon = iconRegister.func_94245_a("magicbees:magnetActive");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.isMagnetActive(damage) ? this.activeIcon : this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack itemStack, int pass) {
        return this.isMagnetActive(itemStack);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            itemStack.func_77964_b(itemStack.func_77960_j() ^ 1);
        }
        return itemStack;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (this.isMagnetActive(itemStack) && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            float radius = this.getRadius(itemStack.func_77960_j()) - 0.2f;
            AxisAlignedBB bounds = player.field_70121_D.func_72314_b((double)radius, (double)radius, (double)radius);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                bounds.func_72314_b((double)0.2f, (double)0.2f, (double)0.2f);
                if (itemStack.func_77960_j() >> 1 >= 7) {
                    List arrows = world.func_72872_a(EntityArrow.class, bounds);
                    for (EntityArrow arrow : arrows) {
                        if (arrow.field_70251_a == 1 && world.field_73012_v.nextInt(6) == 0) {
                            EntityItem replacement = new EntityItem(world, arrow.field_70165_t, arrow.field_70163_u, arrow.field_70161_v, new ItemStack(Items.field_151032_g));
                            world.func_72838_d((Entity)replacement);
                        }
                        world.func_72900_e((Entity)arrow);
                    }
                }
            }
            List list = world.func_72872_a(EntityItem.class, bounds);
            for (EntityItem e : list) {
                if (e.field_70292_b < 10) continue;
                double x = player.field_70165_t - e.field_70165_t;
                double y = player.field_70163_u - e.field_70163_u;
                double z = player.field_70161_v - e.field_70161_v;
                double length = Math.sqrt(x * x + y * y + z * z) * 2.0;
                x = x / length + player.field_70159_w / 2.0;
                y = y / length + player.field_70181_x / 2.0;
                z = z / length + player.field_70179_y / 2.0;
                e.field_70159_w = x;
                e.field_70181_x = y;
                e.field_70179_y = z;
                e.field_70160_al = true;
                if (e.field_70123_F) {
                    e.field_70181_x += 1.0;
                }
                if (world.field_73012_v.nextInt(20) != 0) continue;
                float pitch = 0.85f - world.field_73012_v.nextFloat() * 3.0f / 10.0f;
                world.func_72908_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, "mob.endermen.portal", 0.6f, pitch);
            }
        }
    }

    private boolean isMagnetActive(ItemStack itemStack) {
        return this.isMagnetActive(itemStack.func_77960_j());
    }

    private boolean isMagnetActive(int damage) {
        return (damage & 1) == 1;
    }

    public int getMaximumLevel() {
        return Config.magnetMaxLevel;
    }

    private float getRadius(int damageValue) {
        return Config.magnetBaseRange + Config.magnetLevelMultiplier * (float)(damageValue >> 1);
    }
}

