/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import magicbees.bees.BeeManager;
import magicbees.item.types.PollenType;
import magicbees.main.Config;
import magicbees.main.utils.BlockInterface;
import magicbees.main.utils.ItemInterface;
import magicbees.main.utils.compat.botania.BotaniaAPIDistanceHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import vazkii.botania.api.mana.ManaItemHandler;

public class BotaniaHelper {
    @SideOnly(value=Side.CLIENT)
    public static IIcon[] subtileIcons;
    public static final String LEXICON_ENTRY_MANA_GEAR = "manaGear";
    public static final String LEXICON_ENTRY_ELF_RESOURCES = "elfResources";
    public static Block blockMysticalFlower;
    public static Block blockLivingRock;
    public static Block blockLivingWood;
    public static Block blockDreamWood;
    public static Item itemPetal;
    public static Item itemManaPetal;
    public static Item itemManaResource;
    public static Item itemPastureSeed;
    public static Item itemRune;
    public static ItemStack[] mysticalFlowerVariants;
    public static IRecipe manasteelGrafterRecipe;
    public static IRecipe manasteelScoopRecipe;
    public static IRecipe manaBoosterRecipe;
    private static boolean isBotaniaActive;
    public static final String Name = "Botania";
    public static double beegoniaManaMultiplier;
    public static double hiveacynthManaMultiplier;
    public static double hiveacynthRainResistRate;
    public static double hiveacynthPrincessSpawnRate;
    public static double hiveacynthPristineRate;
    public static double hibeescusTicksMultiplier;
    public static double hibeescusManaCostMultiplier;

    public static boolean isActive() {
        return isBotaniaActive;
    }

    public static void preInit() {
        if (Loader.isModLoaded((String)Name) && Config.botaniaActive) {
            isBotaniaActive = true;
        }
    }

    public static void init() {
        if (BotaniaHelper.isActive()) {
            BotaniaHelper.getBlocks();
            BotaniaHelper.getItems();
            BotaniaAPIDistanceHelper.registerSubtiles();
        }
    }

    public static void postInit() {
        if (BotaniaHelper.isActive()) {
            BeeManager.populateSpeciesListRarity();
            GameRegistry.addRecipe((ItemStack)new ItemStack(Config.manasteelScoop), (Object[])new Object[]{"twt", "tmt", " t ", Character.valueOf('m'), new ItemStack(itemManaResource, 1, ManaResource.MANASTEEL.ordinal()), Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('t'), Items.field_151055_y});
            manasteelScoopRecipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(CraftingManager.func_77594_a().func_77592_b().size() - 1);
            GameRegistry.addRecipe((ItemStack)new ItemStack(Config.manasteelGrafter), (Object[])new Object[]{"  m", " t ", "t  ", Character.valueOf('m'), new ItemStack(itemManaResource, 1, ManaResource.MANASTEEL.ordinal()), Character.valueOf('t'), Items.field_151055_y});
            manasteelGrafterRecipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(CraftingManager.func_77594_a().func_77592_b().size() - 1);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)Config.manaAuraProvider), (Object[])new Object[]{"lsl", "pmp", "sss", Character.valueOf('s'), blockLivingRock, Character.valueOf('m'), new ItemStack(itemManaResource, 1, ManaResource.MANASTEEL.ordinal()), Character.valueOf('p'), Config.pollen.getStackForType(PollenType.UNUSUAL), Character.valueOf('l'), new ItemStack(itemManaPetal, 1, Short.MAX_VALUE)});
            manaBoosterRecipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(CraftingManager.func_77594_a().func_77592_b().size() - 1);
            BotaniaAPIDistanceHelper.setupCraftingAndLexicon();
        }
    }

    public static void getBlocks() {
        blockMysticalFlower = BlockInterface.getBlock(Name, "flower");
        blockLivingRock = BlockInterface.getBlock(Name, "livingrock");
        blockLivingWood = BlockInterface.getBlock(Name, "livingwood");
        blockDreamWood = BlockInterface.getBlock(Name, "dreamwood");
        mysticalFlowerVariants = new ItemStack[16];
        for (int i = 0; i < 16; ++i) {
            BotaniaHelper.mysticalFlowerVariants[i] = new ItemStack(blockMysticalFlower, 1, i);
        }
    }

    public static void getItems() {
        itemPetal = ItemInterface.getItem(Name, "petal");
        itemManaPetal = ItemInterface.getItem(Name, "manaPetal");
        itemManaResource = ItemInterface.getItem(Name, "manaResource");
        itemPastureSeed = ItemInterface.getItem(Name, "grassSeeds");
        itemRune = ItemInterface.getItem(Name, "rune");
    }

    public static void doBotaniaModuleConfigs(Configuration configuration) {
        Property p = configuration.get("botaniaPlugin", "beegoniaManaMultiplier", 1.0);
        p.comment = "Multiplier for the Beegonia's mana generation. Default: 1.0 (Affects duration, not throughput)";
        beegoniaManaMultiplier = p.getDouble();
        p = configuration.get("botaniaPlugin", "hiveacynthManaMultiplier", 1.0);
        p.comment = "Multiplier for the Hiveacynth's mana consumption. Default: 1.0";
        hiveacynthManaMultiplier = p.getDouble();
        p = configuration.get("botaniaPlugin", "hiveacynthRainResistRate", 0.1);
        p.comment = "Rate at which the Hiveacynth applies rain resist to spawned bees. Default: 0.1 Setting to 0 will disable.";
        hiveacynthRainResistRate = p.getDouble();
        p = configuration.get("botaniaPlugin", "hiveacynthPrincessSpawnRate", 0.09);
        p.comment = "Rate at which the Hiveacynth will spawn a Princess instead of a Drone. Default: 0.09. Setting to 0 will disable.";
        hiveacynthPrincessSpawnRate = p.getDouble();
        p = configuration.get("botaniaPlugin", "hiveacynthPristineRate", 0.15);
        p.comment = "Rate at which the Hiveacynth will produce a Pristine Princess, when it produces a princess. Default: 0.15. Setting to 0 will disable, setting to 1 will make every Princess produced pristine..";
        hiveacynthPristineRate = p.getDouble();
        p = configuration.get("botaniaPlugin", "hibeescusManaCostMultiplier", 1.0);
        p.comment = "Multiplier on Hibeescus mana cost, base 10,000. Default 1.0. Setting to 0 makes you a huge cheater. <3";
        hibeescusManaCostMultiplier = p.getDouble();
        p = configuration.get("botaniaPlugin", "hibeescusTicksMultiplier", 1.0);
        p.comment = "Multiplier for Hibeescus operation tick time. Multiplied against 1.5 Minecraft days with some extra randomness. Default: 1.0. Setting to 0 makes you a huge cheater. <3";
        hibeescusTicksMultiplier = p.getDouble();
    }

    public static boolean requestMana(ItemStack stack, EntityPlayer player, int manaPerDamage, int charges) {
        return ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)(manaPerDamage * charges), (boolean)true);
    }

    public static ItemStack getRune(Rune rune, int quantity) {
        return new ItemStack(itemRune, quantity, rune.ordinal());
    }

    static {
        isBotaniaActive = false;
    }

    public static enum Rune {
        WATER,
        FIRE,
        EARTH,
        AIR,
        SPRING,
        SUMMER,
        AUTUMN,
        WINTER,
        MANA,
        LUST,
        GLUTTONY,
        GREED,
        SLOTH,
        WRATH,
        ENVY,
        PRIDE;

    }

    public static enum PastureSeed {
        GRASS,
        PODZOL,
        MYCELIUM;

    }

    public static enum ManaResource {
        MANASTEEL,
        MANAPEARL,
        MANADIAMOND,
        LIVINGWOOD_TWIG,
        TERRASTEEL,
        LIFE_ESSENCE,
        REDSTONE_ROOT,
        ELEMENTIUM,
        PIXIE_DUST,
        DRAGONSTONE,
        PRISMARINE_SHARD,
        PLACEHOLDER,
        RED_STRING,
        DREAMWOOD_TWIG,
        GAIA_INGOT,
        ENDER_AIR_BOTTLE,
        MANA_STRING;

    }
}

