/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.compat.botania;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import magicbees.bees.BeeManager;
import magicbees.main.utils.compat.BotaniaHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.subtile.SubTileFunctional;

public class SubTileHibeescus
extends SubTileFunctional {
    public static final String NAME = "hibeescus";
    private final int MANA_PER_OPERATION = 10000;
    private final int OPERATION_TICKS_TIME = 18000;
    private final int RANGE = 1;
    private ItemStack beeSlot;
    private long operationTicksRemaining;

    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.beeSlot != null && this.mana >= 10000) {
            this.progressOperation();
        } else if (this.beeSlot == null && this.supertile.func_145831_w().func_82737_E() % 10L == 0L && this.redstoneSignal == 0) {
            this.findBeeItemToHold();
        }
    }

    private void progressOperation() {
        --this.operationTicksRemaining;
        if (this.operationTicksRemaining <= 0L) {
            this.mana -= 10000;
            IBee bee = BeeManager.beeRoot.getMember(this.beeSlot);
            bee.setIsNatural(true);
            EnumBeeType beeType = EnumBeeType.QUEEN;
            if (bee.getMate() == null) {
                beeType = EnumBeeType.PRINCESS;
            }
            ItemStack outputStack = BeeManager.beeRoot.getMemberStack((IIndividual)bee, beeType.ordinal());
            Random r = this.supertile.func_145831_w().field_73012_v;
            EntityItem entity = new EntityItem(this.supertile.func_145831_w(), (double)(this.supertile.field_145851_c - 1 + r.nextInt(3)), (double)(this.supertile.field_145848_d + 1), (double)(this.supertile.field_145849_e - 1 + r.nextInt(3)), outputStack);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            this.supertile.func_145831_w().func_72838_d((Entity)entity);
            this.beeSlot = null;
        }
    }

    private void findBeeItemToHold() {
        List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, this.getSearchBoundingBox());
        for (EntityItem itemEntity : items) {
            ItemStack item = itemEntity.func_92059_d();
            if (itemEntity.field_70128_L || !this.isItemPrincessOrQueen(item)) continue;
            this.beeSlot = itemEntity.func_92059_d();
            itemEntity.func_70106_y();
            this.operationTicksRemaining = (long)(18000.0 * BotaniaHelper.hibeescusTicksMultiplier);
            if (this.operationTicksRemaining > 0L) {
                this.operationTicksRemaining += (long)this.supertile.func_145831_w().field_73012_v.nextInt((int)((double)this.operationTicksRemaining * 0.02));
            }
            --item.field_77994_a;
            if (item.field_77994_a > 0) break;
            itemEntity.func_70106_y();
            break;
        }
    }

    private boolean isItemPrincessOrQueen(ItemStack stack) {
        IBee bee;
        boolean isBee;
        boolean bl = isBee = BeeManager.beeRoot.isMember(stack, EnumBeeType.PRINCESS.ordinal()) || BeeManager.beeRoot.isMember(stack, EnumBeeType.QUEEN.ordinal());
        return isBee && !(bee = BeeManager.beeRoot.getMember(stack)).isNatural();
    }

    private AxisAlignedBB getSearchBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.supertile.field_145851_c - 1), (double)this.supertile.field_145848_d, (double)(this.supertile.field_145849_e - 1), (double)(this.supertile.field_145851_c + 1 + 1), (double)(this.supertile.field_145848_d + 1), (double)(this.supertile.field_145849_e + 1 + 1));
    }

    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        if (cmp.func_74764_b("slot")) {
            NBTTagCompound itemTag = (NBTTagCompound)cmp.func_74781_a("slot");
            this.beeSlot = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        }
        this.operationTicksRemaining = cmp.func_74763_f("operationTicks");
    }

    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        if (this.beeSlot != null) {
            NBTTagCompound itemTag = new NBTTagCompound();
            this.beeSlot.func_77955_b(itemTag);
            cmp.func_74782_a("slot", (NBTBase)itemTag);
        }
        cmp.func_74772_a("operationTicks", this.operationTicksRemaining);
    }

    public ArrayList<ItemStack> getDrops(ArrayList<ItemStack> list) {
        if (this.beeSlot != null) {
            list.add(this.beeSlot);
        }
        return super.getDrops(list);
    }

    public int getMaxMana() {
        return (int)(10000.0 * BotaniaHelper.hibeescusManaCostMultiplier);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return BotaniaAPI.getSignatureForName((String)NAME).getIconForStack(null);
    }

    public boolean acceptsRedstone() {
        return true;
    }
}

