/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gas;

import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.gas.AbstractGasConduit;
import crazypants.enderio.conduit.gas.AbstractGasTankConduitNetwork;
import crazypants.enderio.conduit.gas.ConduitGasTank;
import crazypants.enderio.conduit.gas.GasUtil;
import crazypants.enderio.conduit.gas.IGasConduit;
import crazypants.enderio.tool.ToolUtil;
import crazypants.util.BlockCoord;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractGasTankConduit
extends AbstractGasConduit {
    protected ConduitGasTank tank = new ConduitGasTank(0);
    protected boolean stateDirty = false;
    protected long lastEmptyTick = 0L;
    protected int numEmptyEvents = 0;

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        if (player.func_71045_bC() == null) {
            return false;
        }
        if (ToolUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
                ForgeDirection connDir = res.component.dir;
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.field_72310_e);
                if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    BlockCoord loc = this.getLocation().getLocation(faceHit);
                    IGasConduit n = ConduitUtil.getConduit((IBlockAccess)this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, IGasConduit.class);
                    if (n == null) {
                        return false;
                    }
                    if (!this.canJoinNeighbour(n)) {
                        return false;
                    }
                    if (!(n instanceof AbstractGasTankConduit)) {
                        return false;
                    }
                    AbstractGasTankConduit neighbour = (AbstractGasTankConduit)n;
                    if (neighbour.getGasType() == null || this.getGasType() == null) {
                        GasStack type = this.getGasType();
                        type = type != null ? type : neighbour.getGasType();
                        neighbour.setGasTypeOnNetwork(neighbour, type);
                        this.setGasTypeOnNetwork(this, type);
                    }
                    return ConduitUtil.joinConduits(this, faceHit);
                }
                if (this.containsExternalConnection(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    GasStack curGasType = null;
                    if (this.getTankNetwork() != null) {
                        curGasType = this.getTankNetwork().getGasType();
                    }
                    ConduitUtil.disconectConduits(this, connDir);
                    this.setGasType(curGasType);
                }
            }
            return true;
        }
        return false;
    }

    private void setGasTypeOnNetwork(AbstractGasTankConduit con, GasStack type) {
        AbstractConduitNetwork<?, ?> n = con.getNetwork();
        if (n != null) {
            AbstractGasTankConduitNetwork network = (AbstractGasTankConduitNetwork)n;
            network.setGasType(type);
        }
    }

    protected abstract boolean canJoinNeighbour(IGasConduit var1);

    public abstract AbstractGasTankConduitNetwork<? extends AbstractGasTankConduit> getTankNetwork();

    public void setGasType(GasStack gasType) {
        if (this.tank.getGas() != null && this.tank.getGas().isGasEqual(gasType)) {
            return;
        }
        if (gasType != null) {
            gasType = gasType.copy();
        } else if (this.tank.getGas() == null) {
            return;
        }
        this.tank.setGas(gasType);
        this.stateDirty = true;
    }

    public ConduitGasTank getTank() {
        return this.tank;
    }

    public GasStack getGasType() {
        GasStack result = null;
        if (this.getTankNetwork() != null) {
            result = this.getTankNetwork().getGasType();
        }
        if (result == null) {
            result = this.tank.getGas();
        }
        return result;
    }

    @Override
    public boolean canOutputToDir(ForgeDirection dir) {
        if (super.canOutputToDir(dir)) {
            IGasHandler ext = this.getExternalHandler(dir);
            return ext != null && ext.canReceiveGas(dir.getOpposite(), this.tank.getGasType());
        }
        return false;
    }

    protected abstract void updateTank();

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.updateTank();
        if (nbtRoot.func_74764_b("tank")) {
            GasStack gas = GasStack.readFromNBT(nbtRoot.func_74775_l("tank"));
            this.tank.setGas(gas);
        } else {
            this.tank.setGas(null);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        GasStack gt = this.getGasType();
        if (GasUtil.isGasValid(gt)) {
            this.updateTank();
            gt = gt.copy();
            gt.amount = this.tank.getStored();
            nbtRoot.func_74782_a("tank", (NBTBase)gt.write(new NBTTagCompound()));
        }
    }
}

