/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IAdvancedTooltipProvider;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.EnergyUpgrade;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelPickaxe;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import crazypants.util.BlockCoord;
import crazypants.util.ItemUtil;
import crazypants.util.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDarkSteelAxe
extends ItemAxe
implements IEnergyContainerItem,
IAdvancedTooltipProvider,
IDarkSteelItem {
    private int logOreId = -1;
    private final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() == DarkSteelItems.itemDarkSteelAxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelAxe.getStoredPower(player) > requiredPower;
    }

    public static int getStoredPower(EntityPlayer player) {
        if (!ItemDarkSteelAxe.isEquipped(player)) {
            return 0;
        }
        return EnergyUpgrade.getEnergyStored(player.func_71045_bC());
    }

    public static ItemDarkSteelAxe create() {
        ItemDarkSteelAxe res = new ItemDarkSteelAxe();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected ItemDarkSteelAxe() {
        super(ItemDarkSteelSword.MATERIAL);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        String str = "darkSteel_axe";
        this.func_77655_b(str);
        this.func_111206_d("enderIO:" + str);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        par3List.add(is);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent evt) {
        if (evt.getPlayer().func_70093_af() && ItemDarkSteelAxe.isEquipped(evt.getPlayer()) && this.isLog(evt.block, evt.blockMetadata)) {
            int powerStored = ItemDarkSteelAxe.getStoredPower(evt.getPlayer());
            TreeHarvestUtil harvester = new TreeHarvestUtil();
            HarvestResult res = new HarvestResult();
            BlockCoord bc = new BlockCoord(evt.x, evt.y, evt.z);
            harvester.harvest(evt.getPlayer().field_70170_p, bc, res);
            ArrayList<BlockCoord> sortedTargets = new ArrayList<BlockCoord>(res.getHarvestedBlocks());
            this.harvestComparator.refPoint = bc;
            Collections.sort(sortedTargets, this.harvestComparator);
            int maxBlocks = powerStored / Config.darkSteelAxePowerUsePerDamagePointMultiHarvest;
            int numUsedPower = 0;
            for (int i = 0; numUsedPower < maxBlocks && i < sortedTargets.size(); ++i) {
                if (!this.doMultiHarvest(evt.getPlayer(), evt.getPlayer().field_70170_p, (BlockCoord)sortedTargets.get(i), evt.block, evt.blockMetadata % 4)) continue;
                ++numUsedPower;
            }
        }
    }

    private boolean doMultiHarvest(EntityPlayer player, World worldObj, BlockCoord bc, Block refBlock, int refMeta) {
        Block block = worldObj.func_147439_a(bc.x, bc.y, bc.z);
        int meta = worldObj.func_72805_g(bc.x, bc.y, bc.z);
        ArrayList itemDrops = block.getDrops(worldObj, bc.x, bc.y, bc.z, meta, 0);
        worldObj.func_147468_f(bc.x, bc.y, bc.z);
        boolean usedPower = false;
        if (itemDrops != null) {
            for (ItemStack stack : itemDrops) {
                worldObj.func_72838_d((Entity)new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.func_77946_l()));
                if (TreeHarvestUtil.canDropApples(block, meta)) {
                    if (worldObj.field_73012_v.nextInt(200) != 0) continue;
                    worldObj.func_72838_d((Entity)new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, new ItemStack(Items.field_151034_e)));
                    continue;
                }
                if (block != refBlock) continue;
                this.applyDamage((EntityLivingBase)player, player.func_71045_bC(), 1, true);
                usedPower = true;
            }
        }
        return usedPower;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if (evt.entityPlayer.func_70093_af() && ItemDarkSteelAxe.isEquippedAndPowered(evt.entityPlayer, Config.darkSteelAxePowerUsePerDamagePointMultiHarvest) && this.isLog(evt.block, evt.metadata)) {
            evt.newSpeed = evt.originalSpeed / Config.darkSteelAxeSpeedPenaltyMultiHarvest;
        }
        if (ItemDarkSteelAxe.isEquipped(evt.entityPlayer) && evt.block.func_149688_o() == Material.field_151584_j) {
            evt.newSpeed = 6.0f;
        }
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        this.applyDamage(par3EntityLivingBase, par1ItemStack, 2, false);
        return true;
    }

    public boolean func_150894_a(ItemStack item, World world, Block block, int x, int y, int z, EntityLivingBase entLiving) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0) {
            this.applyDamage(entLiving, item, 1, false);
        }
        return true;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (world.field_72995_K) {
            return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, x, y, z, side, par8, par9, par10);
        }
        return false;
    }

    private void applyDamage(EntityLivingBase entity, ItemStack stack, int damage, boolean isMultiharvest) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            int powerUse = isMultiharvest ? Config.darkSteelAxePowerUsePerDamagePointMultiHarvest : Config.darkSteelAxePowerUsePerDamagePoint;
            eu.extractEnergy(damage * powerUse, false);
        } else {
            damage = stack.func_77960_j() + damage;
            if (damage >= this.func_77612_l()) {
                stack.field_77994_a = 0;
            }
            stack.func_77964_b(damage);
        }
        if (eu != null) {
            eu.writeToItem(stack);
        }
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 || this.getEnergyStored(stack) > 0) {
                return ItemDarkSteelSword.MATERIAL.func_77998_b() + Config.darkSteelAxeEffeciencyBoostWhenPowered;
            }
            return ItemDarkSteelSword.MATERIAL.func_77998_b();
        }
        return super.getDigSpeed(stack, block, meta);
    }

    private boolean isLog(Block block, int meta) {
        if (this.logOreId == -1) {
            this.logOreId = OreDictionary.getOreID((String)"logWood");
        }
        int targetOreId = OreDictionary.getOreID((ItemStack)new ItemStack(block, 1, meta));
        int workAroundId = OreDictionary.getOreID((ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
        return targetOreId == this.logOreId || workAroundId == this.logOreId;
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyUpgrade.extractEnergy(container, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    @Override
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString(itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(Lang.localize("item.darkSteel_axe.tooltip.multiHarvest"));
            list.add(EnumChatFormatting.WHITE + "+" + Config.darkSteelAxeEffeciencyBoostWhenPowered + " " + Lang.localize("item.darkSteel_pickaxe.tooltip.effPowered"));
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockCoord> {
        BlockCoord refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockCoord arg0, BlockCoord arg1) {
            int d1 = this.refPoint.distanceSquared(arg0);
            int d2 = this.refPoint.distanceSquared(arg1);
            return MultiHarvestComparator.compare(d1, d1);
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

