/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.capbank.ContainerCapBank;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.network.NetworkState;
import crazypants.enderio.machine.capbank.packet.PacketGuiChange;
import crazypants.enderio.machine.capbank.packet.PacketNetworkStateRequest;
import crazypants.enderio.machine.gui.GuiOverlayIoConfig;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.gui.GuiContainerBase;
import crazypants.gui.GuiToolTip;
import crazypants.gui.IGuiScreen;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import crazypants.vecmath.VecmathUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiCapBank
extends GuiContainerBase {
    private static final NetworkState EMPTY_STATE = new NetworkState();
    private static final CapBankClientNetwork NULL_NETWORK = new CapBankClientNetwork(-1);
    protected static final int INPUT_BUTTON_ID = 18;
    protected static final int OUTPUT_BUTTON_ID = 37;
    protected static final int CONFIG_ID = 377996104;
    private static final int POWER_X = 29;
    private static final int POWER_Y = 9;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 68;
    protected static final int BOTTOM_POWER_Y = 77;
    private int inputX = 102;
    private int inputY = 18;
    private int outputX = 102;
    private int outputY = 36;
    private int rightMargin = 32;
    private final TileCapBank capBank;
    private RedstoneModeButton inputRsButton;
    private RedstoneModeButton outputRsButton;
    private GuiTextField maxInputTF;
    private GuiTextField maxOutputTF;
    private GuiOverlayIoConfig configOverlay;
    private IconButtonEIO configB;
    private CapBankClientNetwork network;
    private int initialStateCount = -1;
    private boolean initState = true;
    private final ContainerCapBank container;

    public GuiCapBank(Entity player, InventoryPlayer playerInv, TileCapBank te) {
        super(new ContainerCapBank(player, playerInv, te));
        this.capBank = te;
        this.container = (ContainerCapBank)this.field_147002_h;
        this.updateState();
        this.field_146999_f = 218;
        this.addToolTip(new GuiToolTip(new Rectangle(5, 9, 10, 68), new String[]{""}){

            @Override
            protected void updateText() {
                this.text.clear();
                this.text.add(PowerDisplayUtil.formatPower(GuiCapBank.this.network.getEnergyStoredL()) + " " + PowerDisplayUtil.ofStr());
                this.text.add(EnumChatFormatting.WHITE + PowerDisplayUtil.formatPower(GuiCapBank.this.network.getMaxEnergyStoredL()) + " " + EnumChatFormatting.GRAY + PowerDisplayUtil.abrevation());
                float change = GuiCapBank.this.network.getAverageChangePerTick();
                String color = EnumChatFormatting.WHITE.toString();
                if (change > 0.0f) {
                    color = EnumChatFormatting.GREEN.toString() + "+";
                } else if (change < 0.0f) {
                    color = EnumChatFormatting.RED.toString();
                }
                this.text.add(String.format("%s%s%s" + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr(), color, PowerDisplayUtil.formatPower(Math.round(change)), " " + EnumChatFormatting.GRAY.toString()));
            }
        });
        int x = this.field_146999_f - this.rightMargin - 16 - 21;
        int y = this.inputY;
        this.inputRsButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                GuiCapBank.this.network.setInputControlMode(mode);
                GuiCapBank.this.sendUpdateToServer();
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return GuiCapBank.this.network.getInputControlMode();
            }
        });
        this.inputRsButton.setTooltipKey("enderio.gui.capBank.inputRs");
        this.outputRsButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y += 18, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                GuiCapBank.this.network.setOutputControlMode(mode);
                GuiCapBank.this.sendUpdateToServer();
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return GuiCapBank.this.network.getOutputControlMode();
            }
        });
        this.outputRsButton.setTooltipKey("enderio.gui.capBank.outputRs");
        this.configB = new IconButtonEIO(this, 377996104, x, y += 20, IconEIO.IO_CONFIG_UP);
        this.configB.setToolTip(Lang.localize("gui.machine.ioMode.overlay.tooltip"));
        ArrayList<BlockCoord> coords = new ArrayList<BlockCoord>();
        if (this.network != null && this.network.getMembers().size() < 200) {
            for (TileCapBank cb : this.network.getMembers()) {
                coords.add(cb.getLocation());
            }
        }
        if (coords.isEmpty()) {
            coords.add(te.getLocation());
        }
        this.configOverlay = new GuiOverlayIoConfig(coords){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                GuiCapBank.this.configB.setIcon(visible ? IconEIO.IO_CONFIG_DOWN : IconEIO.IO_CONFIG_UP);
            }

            @Override
            protected String getLabelForMode(IoMode mode) {
                if (mode == IoMode.PUSH) {
                    return Lang.localize("gui.capBank.outputMode");
                }
                if (mode == IoMode.PULL) {
                    return Lang.localize("gui.capBank.inputMode");
                }
                return super.getLabelForMode(mode);
            }
        };
        this.addOverlay(this.configOverlay);
    }

    protected void func_146284_a(GuiButton b) {
        super.func_146284_a(b);
        if (b.field_146127_k == 377996104) {
            boolean vis = !this.configOverlay.isVisible();
            this.configOverlay.setVisible(vis);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.configB.onGuiInit();
        int x = this.field_147003_i + this.field_146999_f - this.rightMargin - 16;
        int y = this.field_147009_r + this.inputY;
        FontRenderer fontRenderer = this.getFontRenderer();
        this.inputRsButton.onGuiInit();
        this.outputRsButton.onGuiInit();
        x = this.field_147003_i + this.inputX;
        y = this.field_147009_r + this.inputY;
        this.maxInputTF = new GuiTextField(fontRenderer, x, y, 68, 16);
        this.maxInputTF.func_146205_d(true);
        this.maxInputTF.func_146203_f(10);
        this.maxInputTF.func_146195_b(false);
        x = this.field_147003_i + this.outputX;
        y = this.field_147009_r + this.outputY;
        this.maxOutputTF = new GuiTextField(fontRenderer, x, y, 68, 16);
        this.maxOutputTF.func_146205_d(true);
        this.maxOutputTF.func_146203_f(10);
        this.maxOutputTF.func_146195_b(true);
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        if (par1 == 'e') {
            super.func_73869_a(par1, 1);
        }
        this.maxInputTF.func_146201_a(par1, par2);
        this.maxOutputTF.func_146201_a(par1, par2);
        this.updateInputOutput();
    }

    private void updateInputOutput() {
        int output;
        int input = PowerDisplayUtil.parsePower(this.maxInputTF);
        if (input >= 0 && this.network.getMaxInput() != input) {
            this.setMaxInput(input);
        }
        if ((output = PowerDisplayUtil.parsePower(this.maxOutputTF)) >= 0 && this.network.getMaxOutput() != output) {
            this.setMaxOutput(output);
        }
    }

    private void setMaxOutput(int output) {
        if (output != this.network.getMaxOutput()) {
            this.network.setMaxOutput(output);
            this.maxOutputTF.func_146180_a(PowerDisplayUtil.formatPower(this.network.getMaxOutput()));
            this.sendUpdateToServer();
        }
    }

    private void setMaxInput(int input) {
        if (input != this.network.getMaxInput()) {
            this.network.setMaxInput(input);
            this.maxInputTF.func_146180_a(PowerDisplayUtil.formatPower(this.network.getMaxInput()));
            this.sendUpdateToServer();
        }
    }

    protected void sendUpdateToServer() {
        if (this.network != NULL_NETWORK) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGuiChange(this.capBank));
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.maxInputTF.func_146192_a(par1, par2, par3);
        this.maxOutputTF.func_146192_a(par1, par2, par3);
    }

    public void func_73876_c() {
        this.maxInputTF.func_146178_a();
        this.maxOutputTF.func_146178_a();
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        this.requestStateUpdate();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture("enderio:textures/gui/capacitorBank.png");
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f - 21, this.field_147000_g);
        int i1 = this.getEnergyStoredScaled(68);
        this.func_73729_b(sx + 29, sy + 77 - i1, 197, 0, 10, i1);
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
            guibutton.func_146112_a(this.field_146297_k, 0, 0);
        }
        this.maxInputTF.func_146194_f();
        this.maxOutputTF.func_146194_f();
        int midX = sx + this.field_146999_f / 2;
        String str = Lang.localize("gui.capBank.maxIo") + " " + PowerDisplayUtil.formatPower(this.network.getMaxIO()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        FontRenderer fontRenderer = this.getFontRenderer();
        int swid = fontRenderer.func_78256_a(str);
        int x = midX - swid / 2;
        int y = this.field_147009_r + 5;
        this.func_73731_b(fontRenderer, str, x, y, -1);
        str = Lang.localize("gui.capBank.maxInput") + ":";
        swid = fontRenderer.func_78256_a(str);
        x = this.field_147003_i + this.inputX - swid - 3;
        y = this.field_147009_r + this.inputY + 2;
        this.func_73731_b(fontRenderer, str, x, y, -1);
        str = Lang.localize("gui.capBank.maxOutput") + ":";
        swid = fontRenderer.func_78256_a(str);
        x = this.field_147003_i + this.outputX - swid - 3;
        y = this.field_147009_r + this.outputY + 2;
        this.func_73731_b(fontRenderer, str, x, y, -1);
    }

    @Override
    public void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        super.drawHoveringText(par1List, par2 + 24, par3, font);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
    }

    @Override
    public int getGuiLeft() {
        return this.field_147003_i + 24;
    }

    @Override
    public int getGuiTop() {
        return this.field_147009_r;
    }

    @Override
    public int getXSize() {
        return this.field_146999_f - 42;
    }

    @Override
    public int getOverlayOffsetX() {
        return 21;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    private int getEnergyStoredScaled(int scale) {
        return (int)VecmathUtil.clamp(Math.round((double)scale * this.network.getEnergyStoredRatio()), 0.0, (double)scale);
    }

    private void requestStateUpdate() {
        if (EnderIO.proxy.getTickCount() % 2L == 0L && !this.updateState()) {
            this.network.requestPowerUpdate(this.capBank, 2);
        }
    }

    private boolean updateState() {
        if (!this.initState) {
            return false;
        }
        if (this.capBank.getNetwork() == null) {
            this.network = NULL_NETWORK;
            return true;
        }
        if (this.network == null || this.network == NULL_NETWORK) {
            this.network = (CapBankClientNetwork)this.capBank.getNetwork();
            this.initialStateCount = this.network.getStateUpdateCount();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(this.capBank));
            return true;
        }
        if (this.network.getStateUpdateCount() == this.initialStateCount) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(this.capBank));
            return true;
        }
        if (this.network.getStateUpdateCount() > this.initialStateCount) {
            this.container.updateInventory();
            this.updateFieldsFromState();
            this.initState = false;
            return true;
        }
        return false;
    }

    private void updateFieldsFromState() {
        this.maxInputTF.func_146180_a(PowerDisplayUtil.formatPower(this.network.getMaxInput()));
        this.maxOutputTF.func_146180_a(PowerDisplayUtil.formatPower(this.network.getMaxOutput()));
        this.inputRsButton.setMode(this.network.getInputControlMode());
        this.outputRsButton.setMode(this.network.getOutputControlMode());
    }
}

