/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import crazypants.enderio.machine.generator.zombie.ModelZombieJar;
import crazypants.enderio.machine.generator.zombie.NutrientTank;
import crazypants.enderio.machine.killera.TileKillerJoe;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class KillerJoeRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static final String TEXTURE = "enderio:models/KillerJoe.png";
    private static final ItemStack DEFAULT_SWORD = new ItemStack(Items.field_151040_l);
    private ModelZombieJar model = new ModelZombieJar();

    public void func_147500_a(TileEntity te, double x, double y, double z, float tick) {
        World world = te.func_145831_w();
        TileKillerJoe gen = (TileKillerJoe)te;
        float swingProg = gen.getSwingProgress(tick);
        float f = world.func_72957_l(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        int l = world.func_72802_i(te.field_145851_c, te.field_145848_d, te.field_145849_e, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        Tessellator.field_78398_a.func_78386_a(f, f, f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.renderModel(gen.facing);
        this.renderSword(gen.facing, gen.func_70301_a(0), gen.getSwingProgress(tick));
        this.renderFluid(gen);
        GL11.glPopMatrix();
    }

    private void renderSword(int facing, ItemStack sword, float swingProgress) {
        if (sword == null || sword.func_77954_c() == null) {
            return;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
        if (dir == ForgeDirection.SOUTH) {
            facing = 0;
        } else if (dir == ForgeDirection.WEST) {
            facing = -1;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        float offset = 90.0f;
        if (dir.offsetX != 0) {
            offset *= -1.0f;
        }
        GL11.glRotatef((float)((float)facing * -90.0f + offset), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL11.glPushMatrix();
        if (swingProgress > 0.0f) {
            float f6 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
            float f7 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
            GL11.glRotatef((float)(f7 * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(f7 * 50.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)-0.25f, (float)0.2f, (float)0.05f);
        RenderUtil.bindItemTexture();
        IIcon icon = sword.func_77954_c();
        float f9 = 0.0625f;
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)f9);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected void renderFluid(TileKillerJoe gen) {
        NutrientTank tank = gen.fuelTank;
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        IIcon icon = tank.getFluid().getFluid().getStillIcon();
        if (icon != null) {
            RenderUtil.bindBlockTexture();
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            float fullness = (float)tank.getFluidAmount() / (float)tank.getCapacity();
            BoundingBox bb = BoundingBox.UNIT_CUBE.scale(0.85, 0.96, 0.85);
            bb = bb.scale(1.0, 0.85 * (double)fullness, 1.0);
            float ty = -(0.85f - (bb.maxY - bb.minY)) / 2.0f;
            Vector3d offset = ForgeDirectionOffsets.offsetScaled(ForgeDirection.values()[gen.facing], -0.075);
            bb = bb.translate((float)offset.x, ty, (float)offset.z);
            int brightness = gen.func_145831_w() == null ? 0xF000F0 : gen.func_145831_w().func_72802_i(gen.field_145851_c, gen.field_145848_d, gen.field_145849_e, 0);
            tes.func_78380_c(brightness);
            tes.func_78386_a(1.0f, 1.0f, 1.0f);
            CubeRenderer.render(bb, icon);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            tes.func_78381_a();
            GL11.glDepthMask((boolean)true);
            GL11.glPopAttrib();
        }
    }

    private void renderModel(int facing) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.2f, (float)0.9f, (float)1.2f);
        ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
        if (dir == ForgeDirection.SOUTH) {
            facing = 0;
        } else if (dir == ForgeDirection.WEST) {
            facing = -1;
        }
        GL11.glRotatef((float)((float)facing * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtil.bindTexture(TEXTURE);
        this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderItem(0.0f, 0.0f, 0.0f);
    }

    private void renderItem(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.renderModel(ForgeDirection.EAST.ordinal());
        this.renderSword(ForgeDirection.EAST.ordinal(), DEFAULT_SWORD, 0.0f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

